/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.circuits;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.circuits.Circuit;

public class CircuitFarmLogic
extends Circuit {
    private final Class<? extends IFarmLogic> logicClass;
    private boolean isManual = false;

    public CircuitFarmLogic(String uid, Class<? extends IFarmLogic> logicClass) {
        super(uid, false);
        this.logicClass = logicClass;
        this.setLimit(4);
    }

    public CircuitFarmLogic setManual() {
        this.isManual = true;
        return this;
    }

    @Override
    public boolean isCircuitable(Object tile) {
        return tile instanceof IFarmHousing;
    }

    private IFarmHousing getCircuitable(Object tile) {
        if (!this.isCircuitable(tile)) {
            return null;
        }
        return (IFarmHousing)tile;
    }

    @Override
    public void onInsertion(int slot, Object tile) {
        IFarmLogic logic;
        IFarmHousing housing = this.getCircuitable(tile);
        if (housing == null) {
            return;
        }
        try {
            logic = this.logicClass.getConstructor(IFarmHousing.class).newInstance(housing);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate logic of class " + this.logicClass.getName() + ": " + ex.getMessage());
        }
        try {
            logic.setManual(this.isManual);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        housing.setFarmLogic(FarmDirection.values()[slot], logic);
    }

    @Override
    public void onLoad(int slot, Object tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, Object tile) {
        IFarmHousing farmHousing = this.getCircuitable(tile);
        if (farmHousing == null) {
            return;
        }
        farmHousing.resetFarmLogic(FarmDirection.values()[slot]);
    }

    @Override
    public void onTick(int slot, Object tile) {
    }
}

