/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.core.EnumTemperature;
import forestry.api.core.IClimateProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.StringUtil;
import net.minecraft.world.World;

public class MutationConditionTemperature
implements IMutationCondition {
    private final EnumTemperature minTemperature;
    private final EnumTemperature maxTemperature;

    public MutationConditionTemperature(EnumTemperature minTemperature, EnumTemperature maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        EnumTemperature biomeTemperature = climate.getTemperature();
        if (biomeTemperature.ordinal() < this.minTemperature.ordinal() || biomeTemperature.ordinal() > this.maxTemperature.ordinal()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public String getDescription() {
        String minString = AlleleManager.climateHelper.toDisplay(this.minTemperature);
        if (this.minTemperature != this.maxTemperature) {
            String maxString = AlleleManager.climateHelper.toDisplay(this.maxTemperature);
            return StringUtil.localize("mutation.condition.temperature.range").replace("%LOW", minString).replace("%HIGH", maxString);
        }
        return StringUtil.localizeAndFormat("mutation.condition.temperature.single", minString);
    }
}

