/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.network.packets;

import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketRipeningUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private int value;

    public PacketRipeningUpdate() {
    }

    public PacketRipeningUpdate(TileFruitPod fruitPod) {
        super(fruitPod);
        this.value = fruitPod.getMaturity();
    }

    public PacketRipeningUpdate(TileLeaves leaves) {
        super(leaves);
        this.value = leaves.getFruitColour();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.RIPENING_UPDATE;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeVarInt(this.value);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.value = data.readVarInt();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IRipeningPacketReceiver) {
            ((IRipeningPacketReceiver)tile).fromRipeningPacket(this.value);
        }
    }
}

