/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.creeper;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.MobHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.creeper.Entity_SpecialCreeper;

public class EntityDrowningCreeper
extends Entity_SpecialCreeper {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "creeper/drowning.png")};

    public EntityDrowningCreeper(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().isImmuneToBurning = true;
        this.getSpecialData().canBreatheInWater = true;
        this.getSpecialData().ignoreWaterPush = true;
        this.field_70728_aV += 4;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power;
        float f = power = powered ? (float)this.field_82226_g * 2.0f : (float)this.field_82226_g;
        if (griefing) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, true);
            MobHelper.drowningExplode((Entity)this, (int)power);
        } else {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, false);
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151133_ar, 1);
        }
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151074_bl, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack itemStack = new ItemStack((Item)Items.field_151024_Q);
        EffectHelper.setItemName(itemStack, "Diving Helmet", 9);
        EffectHelper.addItemText(itemStack, "\u00a77\u00a7oBelongs to: Scuba Steve");
        EffectHelper.addItemText(itemStack, "\u00a77\u00a7oIf found, please return to \u00a7khome");
        EffectHelper.dye(itemStack, 0x99CCFF);
        EffectHelper.enchantItem(itemStack, Enchantment.field_77340_h, 10);
        EffectHelper.enchantItem(itemStack, Enchantment.field_77341_i, 1);
        EffectHelper.enchantItem(itemStack, Enchantment.field_77347_r, 3);
        this.func_70099_a(itemStack, 0.0f);
    }
}

