/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.pigzombie.Entity_SpecialPigZombie;
import toast.specialMobs.network.MessageExplosion;

public abstract class MobHelper {
    private static Stream<EntityAITasks.EntityAITaskEntry> typeFilteredTaskEntries(EntityLiving entity, Class<?> type) {
        EntityAITasks.EntityAITaskEntry[] array = entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0]);
        return Arrays.stream(array).filter(Objects::nonNull).filter(e -> type.isInstance(e.field_75733_a));
    }

    public static void clearMeleeAttackAI(EntityLiving entity) {
        MobHelper.typeFilteredTaskEntries(entity, EntityAIAttackOnCollide.class).forEach(e -> entity.field_70714_bg.func_85156_a(e.field_75733_a));
    }

    public static void clearRangedAttackAI(EntityLiving entity) {
        MobHelper.typeFilteredTaskEntries(entity, EntityAIArrowAttack.class).forEach(e -> entity.field_70714_bg.func_85156_a(e.field_75733_a));
    }

    public static boolean hasRangedAttack(EntityLiving entity) {
        if (MobHelper.typeFilteredTaskEntries(entity, EntityAIArrowAttack.class).findAny().isPresent()) {
            return true;
        }
        return entity instanceof Entity_SpecialPigZombie && ((Entity_SpecialPigZombie)entity).willShootBow() && entity.func_70694_bm() != null && entity.func_70694_bm().func_77973_b() instanceof ItemBow;
    }

    public static void dropFewArrows(EntityLivingBase entity, boolean recentlyHit, int looting) {
        if (entity.func_70694_bm() == null || !(entity.func_70694_bm().func_77973_b() instanceof ItemBow)) {
            return;
        }
        int i = entity.func_70681_au().nextInt(3 + looting);
        while (i-- > 0) {
            entity.func_145779_a(Items.field_151032_g, 1);
        }
    }

    public static void darkExplode(Entity exploder, int radius) {
        Explosion explosion = new Explosion(exploder.field_70170_p, exploder, exploder.field_70165_t, exploder.field_70163_u, exploder.field_70161_v, (float)radius);
        float blastPower = explosion.field_77280_f * (0.7f + exploder.field_70170_p.field_73012_v.nextFloat() * 0.6f);
        HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>();
        int bX = (int)exploder.field_70165_t;
        int bY = (int)exploder.field_70163_u;
        int bZ = (int)exploder.field_70161_v;
        for (int x = -(radius <<= 2); x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    float resistance;
                    Block block;
                    if (Math.sqrt(x * x + y * y + z * z) > (double)radius || (block = exploder.field_70170_p.func_147439_a(bX + x, bY + y, bZ + z)) == null || block.func_149750_m() <= 1 || block instanceof BlockLiquid || block instanceof BlockFire || block == Blocks.field_150439_ay || block instanceof BlockOre || !(blastPower - (resistance = exploder.func_145772_a(explosion, exploder.field_70170_p, bX + x, bY + y, bZ + z, block) + 0.3f) * 0.3f > 0.0f) || !exploder.func_145774_a(explosion, exploder.field_70170_p, bX + x, bY + y, bZ + z, block, blastPower)) continue;
                    affectedBlocks.add(new ChunkPosition(bX + x, bY + y, bZ + z));
                }
            }
        }
        explosion.field_77281_g.addAll(affectedBlocks);
        explosion.func_77279_a(false);
        _SpecialMobs.CHANNEL.sendToDimension((IMessage)new MessageExplosion(explosion), exploder.field_71093_bK);
    }

    public static void dirtExplode(Entity exploder, int radius) {
        int bX = (int)exploder.field_70165_t;
        int bY = (int)exploder.field_70163_u;
        int bZ = (int)exploder.field_70161_v;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.sqrt(x * x + y * y + z * z) > (double)radius || !Blocks.field_150346_d.func_149742_c(exploder.field_70170_p, bX + x, bY + y, bZ + z)) continue;
                    exploder.field_70170_p.func_147465_d(bX + x, bY + y, bZ + z, Blocks.field_150346_d, 0, 2);
                }
            }
        }
    }

    public static void drowningExplode(Entity exploder, int radius) {
        int bX = (int)exploder.field_70165_t;
        int bY = (int)exploder.field_70163_u;
        int bZ = (int)exploder.field_70161_v;
        for (int x = -(radius += 3); x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= (double)radius)) continue;
                    if (dist > (double)(radius - 1)) {
                        if (!Blocks.field_150347_e.func_149742_c(exploder.field_70170_p, bX + x, bY + y, bZ + z)) continue;
                        if (exploder.field_70170_p.field_73012_v.nextFloat() < 0.25f) {
                            exploder.field_70170_p.func_147465_d(bX + x, bY + y, bZ + z, Blocks.field_150418_aU, 1, 2);
                            continue;
                        }
                        exploder.field_70170_p.func_147465_d(bX + x, bY + y, bZ + z, Blocks.field_150347_e, 0, 2);
                        continue;
                    }
                    if (!Blocks.field_150355_j.func_149742_c(exploder.field_70170_p, bX + x, bY + y, bZ + z)) continue;
                    exploder.field_70170_p.func_147465_d(bX + x, bY + y, bZ + z, Blocks.field_150355_j, 0, 2);
                }
            }
        }
    }

    public static void gravelExplode(Entity exploder, float power) {
        int count = (int)Math.ceil((power += 4.0f) * power * 3.5f);
        for (int i = 0; i < count; ++i) {
            EntityFallingBlock gravel = new EntityFallingBlock(exploder.field_70170_p, exploder.field_70165_t, exploder.field_70163_u + (double)(exploder.field_70131_O / 2.0f), exploder.field_70161_v, Blocks.field_150351_n);
            gravel.field_145812_b = 1;
            gravel.field_145813_c = false;
            gravel.func_145806_a(true);
            gravel.field_70143_R = 3.0f;
            float speed = (power * 0.7f + exploder.field_70170_p.field_73012_v.nextFloat() * power) / 20.0f;
            float pitch = exploder.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI;
            float yaw = exploder.field_70170_p.field_73012_v.nextFloat() * 2.0f * (float)Math.PI;
            gravel.field_70159_w = MathHelper.func_76134_b((float)yaw) * speed;
            gravel.field_70181_x = MathHelper.func_76126_a((float)pitch) * (power + exploder.field_70170_p.field_73012_v.nextFloat() * power) / 18.0f;
            gravel.field_70179_y = MathHelper.func_76126_a((float)yaw) * speed;
            exploder.field_70170_p.func_72838_d((Entity)gravel);
        }
    }

    public static void lightningExplode(Entity exploder, int radius) {
        MobHelper.lightningExplode(exploder, exploder.field_70165_t, exploder.field_70163_u, exploder.field_70161_v, radius);
    }

    public static void lightningExplode(Entity exploder, double posX, double posY, double posZ, int radius) {
        for (int x = -(radius /= 3); x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                exploder.field_70170_p.func_72838_d((Entity)new EntityLightningBolt(exploder.field_70170_p, posX + (double)x, posY, posZ + (double)z));
            }
        }
        _SpecialMobs.CHANNEL.sendToDimension((IMessage)new MessageExplosion(posX, posY, posZ, radius, "lightning"), exploder.field_71093_bK);
    }

    public static ItemStack removeHeldItem(EntityPlayer player) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem != null) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        }
        return heldItem;
    }

    public static ItemStack removeRandomItem(EntityPlayer player) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null) continue;
            ++count;
        }
        if (count > 0) {
            count = _SpecialMobs.random.nextInt(count);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = player.field_71071_by.func_70301_a(i);
                if (item == null || --count >= 0) continue;
                player.field_71071_by.func_70299_a(i, null);
                return item;
            }
        }
        return null;
    }

    public static boolean isCritical(DamageSource damageSource) {
        if (damageSource.func_76364_f() instanceof EntityArrow) {
            return ((EntityArrow)damageSource.func_76364_f()).func_70241_g();
        }
        return damageSource.func_76346_g() != null && !damageSource.func_76346_g().func_70090_H() && damageSource.func_76346_g().field_70143_R > 0.0f;
    }

    public static boolean canReplace(EntityLiving entity) {
        return !entity.func_104002_bU() && !(entity instanceof ISpecialMob) && entity.getEntityData().func_74771_c("smi") == 0;
    }

    public static String getDisplayNameForEntity(String mobName) {
        return StatCollector.func_74838_a((String)("entity." + mobName + ".name"));
    }
}

