/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.forestry;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import java.lang.reflect.Method;
import java.util.Locale;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.interfaces.ICraftingParts;
import logisticspipes.proxy.interfaces.IForestryProxy;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ForestryProxy
implements IForestryProxy {
    private final Class<?> analyserClass = Class.forName("forestry.core.tiles.TileAnalyzer");
    private final Method localize;
    private final Item propolis;
    private final Item pollen;
    private final FluidStack honey;
    private final IBeeRoot root;

    public ForestryProxy() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> stringUtil = Class.forName("forestry.core.utils.StringUtil");
        this.localize = stringUtil.getDeclaredMethod("localize", String.class);
        this.localize.setAccessible(true);
        this.propolis = GameRegistry.findItem((String)"Forestry", (String)"propolis");
        this.pollen = GameRegistry.findItem((String)"Forestry", (String)"pollen");
        this.honey = FluidRegistry.getFluidStack((String)"for.honey", (int)1500);
        this.root = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    @Override
    public boolean isBee(ItemIdentifier item) {
        return this.isBee(item.unsafeMakeNormalStack(1));
    }

    @Override
    public boolean isBee(ItemStack item) {
        return this.root.isMember(item);
    }

    @Override
    public boolean isAnalysedBee(ItemIdentifier item) {
        return this.isAnalysedBee(item.unsafeMakeNormalStack(1));
    }

    @Override
    public boolean isAnalysedBee(ItemStack item) {
        if (!this.isBee(item)) {
            return false;
        }
        return this.root.getMember(item).isAnalyzed();
    }

    @Override
    public boolean isTileAnalyser(TileEntity tile) {
        try {
            if (this.analyserClass.isAssignableFrom(tile.getClass())) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isKnownAlleleId(String allele, World world) {
        if (!(AlleleManager.alleleRegistry.getAllele(allele) instanceof IAlleleBeeSpecies)) {
            return false;
        }
        if (!((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(allele)).isSecret()) {
            return true;
        }
        return this.root.getBreedingTracker(world, MainProxy.proxy.getClientPlayer().func_146103_bH()).isDiscovered((IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(allele));
    }

    @Override
    public String getAlleleName(String uid) {
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleSpecies)) {
            return "";
        }
        return AlleleManager.alleleRegistry.getAllele(uid).getName();
    }

    private String getFirstValidAllele(World world) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies) || !this.isKnownAlleleId(allele.getUID(), world)) continue;
            return allele.getUID();
        }
        return "";
    }

    private String getLastValidAllele(World world) {
        String uid = "";
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies) || !this.isKnownAlleleId(allele.getUID(), world)) continue;
            uid = allele.getUID();
        }
        return uid;
    }

    @Override
    public String getNextAlleleId(String uid, World world) {
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return this.getFirstValidAllele(world);
        }
        boolean next = false;
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            if (next && this.isKnownAlleleId(allele.getUID(), world)) {
                return allele.getUID();
            }
            if (!allele.getUID().equals(uid)) continue;
            next = true;
        }
        return "";
    }

    @Override
    public String getPrevAlleleId(String uid, World world) {
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return this.getLastValidAllele(world);
        }
        IAllele lastAllele = null;
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            if (allele.getUID().equals(uid)) {
                if (lastAllele == null) {
                    return "";
                }
                return lastAllele.getUID();
            }
            if (!this.isKnownAlleleId(allele.getUID(), world)) continue;
            lastAllele = allele;
        }
        return "";
    }

    @Override
    public String getFirstAlleleId(ItemStack bee) {
        if (!this.isBee(bee)) {
            return "";
        }
        return this.root.getMember(bee).getGenome().getPrimary().getUID();
    }

    @Override
    public String getSecondAlleleId(ItemStack bee) {
        if (!this.isBee(bee)) {
            return "";
        }
        return this.root.getMember(bee).getGenome().getSecondary().getUID();
    }

    @Override
    public boolean isDrone(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.isDrone(bee);
    }

    @Override
    public boolean isPrincess(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        if (this.isQueen(bee)) {
            return false;
        }
        return !this.isDrone(bee);
    }

    @Override
    public boolean isQueen(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.isMated(bee);
    }

    @Override
    public boolean isPurebred(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).isPureBred((IChromosomeType)EnumBeeChromosome.SPECIES);
    }

    @Override
    public boolean isNocturnal(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getNocturnal();
    }

    @Override
    public boolean isPureNocturnal(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getNocturnal() && this.root.getMember(bee).isPureBred((IChromosomeType)EnumBeeChromosome.NOCTURNAL);
    }

    @Override
    public boolean isFlyer(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getTolerantFlyer();
    }

    @Override
    public boolean isPureFlyer(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getTolerantFlyer() && this.root.getMember(bee).isPureBred((IChromosomeType)EnumBeeChromosome.TOLERANT_FLYER);
    }

    @Override
    public boolean isCave(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getCaveDwelling();
    }

    @Override
    public boolean isPureCave(ItemStack bee) {
        if (!this.isBee(bee)) {
            return false;
        }
        return this.root.getMember(bee).getGenome().getCaveDwelling() && this.root.getMember(bee).isPureBred((IChromosomeType)EnumBeeChromosome.CAVE_DWELLING);
    }

    @Override
    public String getForestryTranslation(String input) {
        try {
            return (String)this.localize.invoke(null, input.toLowerCase(Locale.US));
        }
        catch (Exception e) {
            e.printStackTrace();
            return input;
        }
    }

    @Override
    public void addCraftingRecipes(ICraftingParts parts) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconIndexForAlleleId(String uid, int phase) {
        IAllele bSpecies = AlleleManager.alleleRegistry.getAllele(uid);
        if (!(bSpecies instanceof IAlleleBeeSpecies)) {
            bSpecies = this.root.getDefaultTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        }
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)bSpecies;
        return species.getIcon(EnumBeeType.DRONE, phase);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorForAlleleId(String uid, int phase) {
        if (!(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) {
            return 0xFFFFFF;
        }
        IAlleleBeeSpecies species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(uid);
        return species.getIconColour(phase);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPassesForAlleleId(String uid) {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromTextureManager(String name) {
        return ForestryAPI.textureManager.getDefault(name);
    }

    @Override
    public void syncTracker(World world, EntityPlayer player) {
        this.root.getBreedingTracker(world, player.func_146103_bH()).synchToPlayer(player);
    }
}

