/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.PlayerConfig;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.modules.ModuleQuickSort;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.PlayerConfigToClientPacket;
import logisticspipes.network.packets.chassis.ChestGuiClosed;
import logisticspipes.network.packets.chassis.ChestGuiOpened;
import logisticspipes.network.packets.gui.GuiReopenPacket;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsGuiOverrenderer;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.QuickSortChestMarkerStorage;
import logisticspipes.utils.WorldUtil;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class LogisticsEventListener {
    public static final WeakHashMap<EntityPlayer, List<WeakReference<ModuleQuickSort>>> chestQuickSortConnection = new WeakHashMap();
    public static Map<ChunkCoordIntPair, PlayerCollectionList> watcherList = new ConcurrentHashMap<ChunkCoordIntPair, PlayerCollectionList>();
    int taskCount = 0;
    public static Map<PlayerIdentifier, PlayerConfig> playerConfigs = new HashMap<PlayerIdentifier, PlayerConfig>();
    public static HashMap<Integer, Long> WorldLoadTime = new HashMap();
    private static final AtomicReference<Object> guiPos = new AtomicReference();

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        ItemStack stack;
        if (event != null && event.entity instanceof EntityItem && event.entity.field_70170_p != null && !event.entity.field_70170_p.field_72995_K && (stack = ((EntityItem)event.entity).func_92059_d()) != null && stack.func_77973_b() instanceof IItemAdvancedExistance && !((IItemAdvancedExistance)stack.func_77973_b()).canExistInWorld(stack)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            LogisticsPipes.textures.registerItemIcons((IIconRegister)event.map);
        }
        if (event.map.func_130086_a() == 0) {
            LogisticsPipes.textures.registerBlockIcons((IIconRegister)event.map);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (MainProxy.isServer(event.entityPlayer.field_70170_p)) {
            TileEntity tile;
            if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (tile = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)) instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe) {
                if (!((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).canBeDestroyedByPlayer(event.entityPlayer)) {
                    event.setCanceled(true);
                    event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                    ((LogisticsTileGenericPipe)tile).scheduleNeighborChange();
                    event.entityPlayer.field_70170_p.func_147471_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                    ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).delayTo = System.currentTimeMillis() + 200L;
                    ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).repeatFor = 10;
                } else {
                    ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).setDestroyByPlayer();
                }
            }
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && ((tile = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)) instanceof TileEntityChest || SimpleServiceLocator.ironChestProxy.isIronChest(tile))) {
                ArrayList<WeakReference<ModuleQuickSort>> list = new ArrayList<WeakReference<ModuleQuickSort>>();
                for (AdjacentTile adj : new WorldUtil(tile).getAdjacentTileEntities()) {
                    if (!(adj.tile instanceof LogisticsTileGenericPipe) || !(((LogisticsTileGenericPipe)adj.tile).pipe instanceof PipeLogisticsChassi) || ((PipeLogisticsChassi)((LogisticsTileGenericPipe)adj.tile).pipe).getPointedOrientation() != adj.orientation.getOpposite()) continue;
                    PipeLogisticsChassi chassi = (PipeLogisticsChassi)((LogisticsTileGenericPipe)adj.tile).pipe;
                    for (int i = 0; i < chassi.getChassiSize(); ++i) {
                        if (!(chassi.getLogisticsModule().getSubModule(i) instanceof ModuleQuickSort)) continue;
                        list.add(new WeakReference<ModuleQuickSort>((ModuleQuickSort)chassi.getLogisticsModule().getSubModule(i)));
                    }
                }
                if (!list.isEmpty()) {
                    chestQuickSortConnection.put(event.entityPlayer, list);
                }
            }
        }
    }

    @SubscribeEvent
    public void WorldLoad(WorldEvent.Load event) {
        int dim;
        if (MainProxy.isServer(event.world) && !WorldLoadTime.containsKey(dim = MainProxy.getDimensionForWorld(event.world))) {
            WorldLoadTime.put(dim, System.currentTimeMillis());
        }
        if (MainProxy.isClient(event.world)) {
            SimpleServiceLocator.routerManager.clearClientRouters();
            LogisticsHUDRenderer.instance().clear();
        }
    }

    @SubscribeEvent
    public void WorldUnload(WorldEvent.Unload event) {
        if (MainProxy.isServer(event.world)) {
            int dim = MainProxy.getDimensionForWorld(event.world);
            SimpleServiceLocator.routerManager.dimensionUnloaded(dim);
        }
    }

    @SubscribeEvent
    public void watchChunk(ChunkWatchEvent.Watch event) {
        if (!watcherList.containsKey(event.chunk)) {
            watcherList.put(event.chunk, new PlayerCollectionList());
        }
        watcherList.get(event.chunk).add((EntityPlayer)event.player);
    }

    @SubscribeEvent
    public void unWatchChunk(ChunkWatchEvent.UnWatch event) {
        if (watcherList.containsKey(event.chunk)) {
            watcherList.get(event.chunk).remove((EntityPlayer)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (MainProxy.isServer(event.player.field_70170_p)) {
            SimpleServiceLocator.securityStationManager.sendClientAuthorizationList(event.player);
            SimpleServiceLocator.craftingPermissionManager.sendCraftingPermissionsToPlayer(event.player);
        }
        SimpleServiceLocator.serverBufferHandler.clear(event.player);
        PlayerConfig config = LogisticsEventListener.getPlayerConfig(PlayerIdentifier.get(event.player));
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(PlayerConfigToClientPacket.class).setConfig(config), event.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        SimpleServiceLocator.serverBufferHandler.clear(event.player);
        PlayerIdentifier ident = PlayerIdentifier.get(event.player);
        PlayerConfig config = playerConfigs.get(ident);
        if (config != null) {
            config.writeToFile();
        }
        playerConfigs.remove(ident);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!LogisticsEventListener.getGuiPos().isEmpty()) {
            GuiEntry part = LogisticsEventListener.getGuiPos().peek();
            if (event.gui == null) {
                if (part.isActive()) {
                    part = LogisticsEventListener.getGuiPos().poll();
                    MainProxy.sendPacketToServer(PacketHandler.getPacket(GuiReopenPacket.class).setGuiID(part.getGuiID()).setPosX(part.getXCoord()).setPosY(part.getYCoord()).setPosZ(part.getZCoord()));
                    LogisticsGuiOverrenderer.getInstance().setOverlaySlotActive(false);
                }
            } else {
                part.setActive(true);
            }
        }
        if (event.gui == null) {
            LogisticsGuiOverrenderer.getInstance().setOverlaySlotActive(false);
        }
        if (event.gui instanceof GuiChest || SimpleServiceLocator.ironChestProxy != null && SimpleServiceLocator.ironChestProxy.isChestGui(event.gui)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ChestGuiOpened.class));
        } else {
            QuickSortChestMarkerStorage.getInstance().disable();
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ChestGuiClosed.class));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addGuiToReopen(int xCoord, int yCoord, int zCoord, int guiID) {
        LogisticsEventListener.getGuiPos().add(new GuiEntry(xCoord, yCoord, zCoord, guiID, false));
    }

    @SubscribeEvent
    public void clientLoggedIn(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        SimpleServiceLocator.clientBufferHandler.clear();
    }

    public static void serverShutdown() {
        for (PlayerConfig config : playerConfigs.values()) {
            config.writeToFile();
        }
        playerConfigs.clear();
    }

    public static PlayerConfig getPlayerConfig(PlayerIdentifier ident) {
        PlayerConfig config = playerConfigs.get(ident);
        if (config == null) {
            config = new PlayerConfig(ident);
            config.readFromFile();
            playerConfigs.put(ident, config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue<GuiEntry> getGuiPos() {
        Serializable value = guiPos.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = guiPos;
            synchronized (atomicReference) {
                value = guiPos.get();
                if (value == null) {
                    LinkedList actualValue = new LinkedList();
                    value = actualValue == null ? guiPos : actualValue;
                    guiPos.set(value);
                }
            }
        }
        return (Queue)((Object)(value == guiPos ? null : value));
    }

    private static class GuiEntry {
        private final int xCoord;
        private final int yCoord;
        private final int zCoord;
        private final int guiID;
        private boolean isActive;

        public GuiEntry(int xCoord, int yCoord, int zCoord, int guiID, boolean isActive) {
            this.xCoord = xCoord;
            this.yCoord = yCoord;
            this.zCoord = zCoord;
            this.guiID = guiID;
            this.isActive = isActive;
        }

        public int getXCoord() {
            return this.xCoord;
        }

        public int getYCoord() {
            return this.yCoord;
        }

        public int getZCoord() {
            return this.zCoord;
        }

        public int getGuiID() {
            return this.guiID;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setActive(boolean isActive) {
            this.isActive = isActive;
        }
    }
}

