/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.tileentity;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import com.arc.bloodarsenal.common.BloodArsenalConfig;
import com.arc.bloodarsenal.common.tileentity.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileLPMaterializer
extends TileEntity
implements IInventory,
IFluidTank,
IFluidHandler {
    private ItemStack[] inv = new ItemStack[1];
    protected FluidStack fluid = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    public int capacity = 20000;
    private boolean canBeFilled;
    protected FluidStack fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
    private int bufferCapacity = 1000;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        if (!par1NBTTagCompound.func_74764_b("Empty")) {
            FluidStack fluidOut;
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)par1NBTTagCompound);
            if (fluid != null) {
                this.setMainFluid(fluid);
            }
            if ((fluidOut = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, par1NBTTagCompound.func_74762_e("outputAmount"))) != null) {
                this.setOutputFluid(fluidOut);
            }
        }
        this.canBeFilled = par1NBTTagCompound.func_74767_n("canBeFilled");
        this.capacity = par1NBTTagCompound.func_74762_e("capacity");
        this.bufferCapacity = par1NBTTagCompound.func_74762_e("bufferCapacity");
        this.readCustomNBT(par1NBTTagCompound);
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        if (this.fluid != null) {
            this.fluid.writeToNBT(par1NBTTagCompound);
        } else {
            par1NBTTagCompound.func_74778_a("Empty", "");
        }
        if (this.fluidOutput != null) {
            par1NBTTagCompound.func_74768_a("outputAmount", this.fluidOutput.amount);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        par1NBTTagCompound.func_74757_a("canBeFilled", this.canBeFilled);
        par1NBTTagCompound.func_74768_a("capacity", this.capacity);
        par1NBTTagCompound.func_74768_a("bufferCapacity", this.bufferCapacity);
        this.writeCustomNBT(par1NBTTagCompound);
    }

    public void readCustomNBT(NBTTagCompound par1NBTTagCompound) {
        NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Inventory", 10);
        if (nbttaglist.func_74745_c() > 0) {
            NBTTagCompound tagList = nbttaglist.func_150305_b(0);
            this.inv[0] = ItemStack.func_77949_a((NBTTagCompound)tagList);
        }
    }

    public void writeCustomNBT(NBTTagCompound par1NBTTagCompound) {
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagCompound tagList = new NBTTagCompound();
        if (this.inv[0] != null) {
            tagList.func_74774_a("Slot", (byte)0);
            this.inv[0].func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)nbttaglist);
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inv[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "TileLPMaterializer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public void sendChatInfoToPlayer(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.tile.contains") + " " + this.getFluidAmount() + "LE"));
    }

    public Packet func_145844_m() {
        return PacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData, int[] fluidData, int capacity) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
        FluidStack flMain = new FluidStack(this.fluid, fluidData[1]);
        FluidStack flIn = new FluidStack(this.fluidOutput, fluidData[3]);
        this.setMainFluid(flMain);
        this.setOutputFluid(flIn);
        this.capacity = capacity;
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        for (ItemStack is : this.inv) {
            int pos = 0;
            if (is != null) {
                sortList[pos++] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[pos++] = is.func_77960_j();
                sortList[pos++] = is.field_77994_a;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    public void func_145845_h() {
        IFluidHandler belowTank;
        IFluidHandler aboveTank;
        super.func_145845_h();
        if (this.getTankAbove() != null && (aboveTank = this.getTankAbove()).canFill(ForgeDirection.DOWN, this.fluid.getFluid())) {
            aboveTank.fill(ForgeDirection.DOWN, this.fluidOutput, true);
            this.drain(ForgeDirection.UP, this.fluidOutput, true);
        }
        if (this.getTankBelow() != null && (belowTank = this.getTankBelow()).canFill(ForgeDirection.UP, this.fluid.getFluid())) {
            belowTank.fill(ForgeDirection.UP, this.fluidOutput, true);
            this.drain(ForgeDirection.DOWN, this.fluidOutput, true);
        }
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.materialize();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_72820_D() % 10L == 0L) {
            int syphonMax = 500;
            int fluidOutputted = Math.min(syphonMax, this.bufferCapacity - this.fluidOutput.amount);
            fluidOutputted = Math.min(this.fluid.amount, fluidOutputted);
            this.fluidOutput.amount += fluidOutputted;
            this.fluid.amount -= fluidOutputted;
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void materialize() {
        ItemStack orb = this.func_70301_a(0);
        if (orb == null) {
            return;
        }
        if (this.fluid.amount <= this.capacity - 100) {
            if (!SoulNetworkHandler.canSyphonFromOnlyNetwork((ItemStack)orb, (int)BloodArsenalConfig.lpMaterializerCost)) {
                SoulNetworkHandler.causeNauseaToPlayer((ItemStack)orb);
                return;
            }
            if (!SoulNetworkHandler.syphonFromNetworkWhileInContainer((ItemStack)orb, (int)BloodArsenalConfig.lpMaterializerCost)) {
                return;
            }
            if (this.field_145850_b.func_72820_D() % 4L == 0L) {
                SpellHelper.sendIndexedParticleToAllAround((World)this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (int)20, (int)this.field_145850_b.field_73011_w.field_76574_g, (int)1, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
            }
            this.fluid.amount += 100;
        }
    }

    private IFluidHandler getTankAbove() {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) != null && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof IFluidHandler ? (IFluidHandler)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) : null;
    }

    private IFluidHandler getTankBelow() {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != null && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof IFluidHandler ? (IFluidHandler)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) : null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.fluidOutput)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidOutput == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluidOutput.amount < drained) {
            drained = this.fluidOutput.amount;
        }
        FluidStack stack = new FluidStack(this.fluidOutput, drained);
        if (doDrain) {
            this.fluidOutput.amount -= drained;
            if (this.fluidOutput.amount <= 0) {
                this.fluidOutput = null;
            }
            if (this != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluidOutput, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, 1000));
            }
        }
        if (this.fluidOutput == null) {
            this.fluidOutput = new FluidStack(AlchemicalWizardry.lifeEssenceFluid, 0);
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return stack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.fluidOutput != null && this.fluid.getFluid().equals(this.fluidOutput.getFluid());
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.drain(maxEmpty, doDrain);
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setOutputFluid(FluidStack fluid) {
        this.fluidOutput = fluid;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTank compositeTank = new FluidTank(this.capacity);
        compositeTank.setFluid(this.fluid);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public int[] buildFluidList() {
        int[] sortList = new int[4];
        if (this.fluid == null) {
            sortList[0] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[1] = 0;
        } else {
            sortList[0] = this.fluid.getFluid().getID();
            sortList[1] = this.fluid.amount;
        }
        if (this.fluidOutput == null) {
            sortList[2] = AlchemicalWizardry.lifeEssenceFluid.getID();
            sortList[3] = 0;
        } else {
            sortList[2] = this.fluidOutput.getFluid().getID();
            sortList[3] = this.fluidOutput.amount;
        }
        return sortList;
    }
}

