/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ProcessingShaping
implements IOreRecipeRegistrator {
    public ProcessingShaping() {
        OrePrefixes.ingot.add(this);
        OrePrefixes.dust.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (!(aMaterial != Materials.Glass && GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) == null || aMaterial.contains(SubTag.NO_SMELTING))) {
            long aMaterialMass = aMaterial.getMass();
            int tAmount = (int)(aPrefix.mMaterialAmount / 3628800L);
            if (tAmount > 0 && tAmount <= 64 && aPrefix.mMaterialAmount % 3628800L == 0L) {
                int tVoltageMultiplier = aMaterial.mBlastFurnaceTemp >= 2800 ? 60 : 15;
                int tTrueVoltage = aMaterial.getProcessingMaterialTierEU();
                if (aMaterial.contains(SubTag.NO_SMASHING)) {
                    tVoltageMultiplier /= 4;
                } else if (aPrefix.name().startsWith(OrePrefixes.dust.name())) {
                    return;
                }
                if (!OrePrefixes.block.isIgnored(aMaterial.mSmeltInto) && GT_OreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack), ItemList.Shape_Extruder_Block.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, (long)tAmount)).duration(10 * tAmount * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                    if ((long)tTrueVoltage < TierEU.IV) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack), ItemList.Shape_Mold_Block.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.block, aMaterial.mSmeltInto, (long)tAmount)).duration(5 * tAmount * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 4 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                    }
                }
                if ((aPrefix != OrePrefixes.ingot || aMaterial != aMaterial.mSmeltInto) && GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Ingot.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, (long)tAmount)).duration(10).eut(GT_Utility.calculateRecipeEU(aMaterial, 4 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Pipe_Tiny.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration(4 * tAmount * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Pipe_Small.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial.mSmeltInto, (long)tAmount)).duration(8 * tAmount * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), ItemList.Shape_Extruder_Pipe_Medium.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial.mSmeltInto, (long)tAmount)).duration(24 * tAmount * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(6L, aStack), ItemList.Shape_Extruder_Pipe_Large.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial.mSmeltInto, (long)tAmount)).duration(48 * tAmount * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(12L, aStack), ItemList.Shape_Extruder_Pipe_Huge.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial.mSmeltInto, (long)tAmount)).duration(96 * tAmount * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Plate.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.gearGtSmall, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Small_Gear.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gearGtSmall, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(6L, aStack), ItemList.Shape_Extruder_Turbine_Blade.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron && aMaterial.mStandardMoltenFluid != null) {
                    if (GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ring.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(36L)).duration(100).eut(GT_Utility.calculateRecipeEU(aMaterial, 4 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.screw, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Screw.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.screw, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(18L)).duration(50).eut(GT_Utility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(72L)).duration(150).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Bolt.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(18L)).duration(50).eut(GT_Utility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.round, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Round.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.round, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(18L)).duration(50).eut(GT_Utility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Rod_Long.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(144L)).duration(300).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Turbine_Blade.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(864L)).duration(400).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Tiny.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(72L)).duration(20).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Small.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(144L)).duration(40).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Medium.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(432L)).duration(80).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Large.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(864L)).duration(160).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                    if (GT_OreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Huge.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(1728L)).duration(320).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                    }
                }
                if (tAmount * 2 <= 64) {
                    if (aMaterial != Materials.Aluminium) {
                        if (GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, 1L) != null) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Rod.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 6 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                    } else if (GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Rod.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.stick, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration(200).eut(GT_Utility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                    }
                }
                if (tAmount * 2 <= 64 && GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Wire.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.wireGt01, aMaterial.mSmeltInto, (long)(tAmount * 2))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 6 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (tAmount * 8 <= 64 && GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Bolt.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.bolt, aMaterial.mSmeltInto, (long)(tAmount * 8))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (tAmount * 4 <= 64) {
                    if (GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial.mSmeltInto, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Ring.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial.mSmeltInto, (long)(tAmount * 4))).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 6 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_SMASHING) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L) != null) {
                        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.ring, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"h ", "fX", Character.valueOf('X'), OrePrefixes.stick.get(aMaterial)});
                    }
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Sword.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), ItemList.Shape_Extruder_Pickaxe.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 3L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Shovel.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 1L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), ItemList.Shape_Extruder_Axe.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 3L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Hoe.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadHammer, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(6L, aStack), ItemList.Shape_Extruder_Hammer.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadHammer, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 6L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadFile, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_File.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadFile, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Saw.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), ItemList.Shape_Extruder_Gear.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 5L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 8 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                }
                if (aMaterial != Materials.StyreneButadieneRubber && aMaterial != Materials.Silicone) {
                    if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, 1L) != null) {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                    }
                } else if ((long)tTrueVoltage < TierEU.IV && GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 2L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                }
                if ((long)tTrueVoltage < TierEU.IV && GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(8L, aStack), ItemList.Shape_Mold_Gear.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial.mSmeltInto, (long)tAmount)).duration((int)Math.max(aMaterialMass * 10L * (long)tAmount, (long)tAmount) * 1).eut(GT_Utility.calculateRecipeEU(aMaterial, 2 * tVoltageMultiplier)).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                }
                switch (aMaterial.mSmeltInto.mName) {
                    case "Glass": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Bottle.get(0L, new Object[0])).itemOutputs(new ItemStack(Items.field_151069_bo, 1)).duration(tAmount * 32 * 1).eut(16).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Mold_Bottle.get(0L, new Object[0])).itemOutputs(new ItemStack(Items.field_151069_bo, 1)).duration(tAmount * 64 * 1).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Steel": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(ItemList.Cell_Empty.get(tAmount, new Object[0])).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingadviron", tAmount * 2)).duration(tAmount * 32 * 1).eut(3 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingadviron", tAmount * 3)).duration(tAmount * 128 * 1).eut(1 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Iron": 
                    case "WroughtIron": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("fuelRod", tAmount)).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingiron", tAmount * 2)).duration(tAmount * 32 * 1).eut(3 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingiron", tAmount * 3)).duration(tAmount * 128 * 1).eut(1 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        }
                        if (tAmount * 31 > 64) break;
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(31L, aStack), ItemList.Shape_Mold_Anvil.get(0L, new Object[0])).itemOutputs(new ItemStack(Blocks.field_150467_bQ, 1, 0)).duration(tAmount * 512 * 1).eut(4 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Tin": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(ItemList.Cell_Empty.get(tAmount, new Object[0])).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingtin", tAmount * 2)).duration(tAmount * 32 * 1).eut(3 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingtin", tAmount * 3)).duration(tAmount * 128 * 1).eut(1 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Lead": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casinglead", tAmount * 2)).duration(tAmount * 32 * 1).eut(3 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casinglead", tAmount * 3)).duration(tAmount * 128 * 1).eut(1 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Copper": 
                    case "AnnealedCopper": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingcopper", tAmount * 2)).duration(tAmount * 32 * 1).eut(3 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingcopper", tAmount * 3)).duration(tAmount * 128 * 1).eut(1 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Bronze": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingbronze", tAmount * 2)).duration(tAmount * 32 * 1).eut(3 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casingbronze", tAmount * 3)).duration(tAmount * 128 * 1).eut(1 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Gold": {
                        if (tAmount * 2 <= 64) {
                            GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casinggold", tAmount * 2)).duration(tAmount * 32 * 1).eut(3 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                        }
                        if (tAmount * 2 > 64) break;
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GT_ModHandler.getIC2Item("casinggold", tAmount * 3)).duration(tAmount * 128 * 1).eut(1 * tVoltageMultiplier).addTo(GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes);
                        break;
                    }
                    case "Polytetrafluoroethylene": {
                        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), ItemList.Shape_Extruder_Cell.get(0L, new Object[0])).itemOutputs(ItemList.Cell_Empty.get(tAmount * 4, new Object[0])).duration(tAmount * 128 * 1).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sExtruderRecipes);
                    }
                }
            }
        }
    }
}

