/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.power.FusionPower;
import gregtech.common.power.Power;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class GT_MetaTileEntity_FusionComputer
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_FusionComputer>
implements ISurvivalConstructable,
IAddUIWidgets {
    protected FusionPower power;
    public static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<GT_MetaTileEntity_FusionComputer>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_FusionComputer>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_FusionComputer> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GT_MetaTileEntity_FusionComputer.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"               ", "      ihi      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " i           i ", " h           h ", " i           i ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      ihi      ", "               "}, {"      xhx      ", "    hhccchh    ", "   eccxhxcce   ", "  eceh   hece  ", " hce       ech ", " hch       hch ", "xcx         xcx", "hch         hch", "xcx         xcx", " hch       hch ", " hce       ech ", "  eceh   hece  ", "   eccx~xcce   ", "    hhccchh    ", "      xhx      "}, {"               ", "      ihi      ", "    hh   hh    ", "   h       h   ", "  h         h  ", "  h         h  ", " i           i ", " h           h ", " i           i ", "  h         h  ", "  h         h  ", "   h       h   ", "    hh   hh    ", "      ihi      ", "               "}})).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getFusionCoil(), (int)t.getFusionCoilMeta()))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasing(), (int)t.getCasingMeta()))).addElement('i', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_FusionComputer.class).atLeast((Map<IHatchElement<GT_MetaTileEntity_FusionComputer>, Number>)ImmutableMap.of(GT_HatchElement.InputHatch.withAdder((rec$, x$0, x$1) -> ((GT_MetaTileEntity_FusionComputer)rec$).addInjector(x$0, x$1)), (Object)2)).hatchItemFilterAnd(t2 -> GT_StructureUtility.filterByMTETier(t2.tier(), Integer.MAX_VALUE)).casingIndex(53).dot(1).buildAndChain(t.getCasing(), t.getCasingMeta()))).addElement('e', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_FusionComputer.class).atLeast((Map<IHatchElement<GT_MetaTileEntity_FusionComputer>, Number>)ImmutableMap.of(GT_HatchElement.Energy.withAdder((rec$, x$0, x$1) -> ((GT_MetaTileEntity_FusionComputer)rec$).addEnergyInjector(x$0, x$1)), (Object)16)).hatchItemFilterAnd(t2 -> GT_StructureUtility.filterByMTETier(t2.tier(), Integer.MAX_VALUE)).casingIndex(53).dot(2).buildAndChain(t.getCasing(), t.getCasingMeta()))).addElement('x', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_FusionComputer.class).atLeast(GT_HatchElement.OutputHatch.withAdder((rec$, x$0, x$1) -> ((GT_MetaTileEntity_FusionComputer)rec$).addExtractor(x$0, x$1))).hatchItemFilterAnd(t2 -> GT_StructureUtility.filterByMTETier(t2.tier(), Integer.MAX_VALUE)).casingIndex(53).dot(3).buildAndChain(t.getCasing(), t.getCasingMeta()))).build();
        }
    };
    public GT_Recipe mLastRecipe;
    public long mEUStore;

    public GT_MetaTileEntity_FusionComputer(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_FusionComputer(String aName) {
        super(aName);
    }

    @Override
    public Power getPower() {
        return this.power;
    }

    public abstract int tier();

    @Override
    public abstract long maxEUStore();

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aStack) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_FusionComputer> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addController("Fusion Reactor").addInfo("Some kind of fusion reactor, maybe").addSeparator().addInfo("Some kind of fusion reactor, maybe").addStructureInfo("Should probably be built similar to other fusions").addStructureInfo("See controller tooltip for details").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 1, 12) && this.mInputHatches.size() > 1 && !this.mOutputHatches.isEmpty() && !this.mEnergyHatches.isEmpty()) {
            this.mWrench = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mHardHammer = true;
            this.mSolderingTool = true;
            this.mCrowbar = true;
            return true;
        }
        return false;
    }

    private boolean addEnergyInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Energy tHatch = (GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity;
        if (tHatch.mTier < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mEnergyHatches.add(tHatch);
    }

    private boolean addInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
        if (tHatch.getTierForStructure() < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        tHatch.mRecipeMap = this.getRecipeMap();
        return this.mInputHatches.add(tHatch);
    }

    private boolean addExtractor(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        if (aBaseMetaTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
        if (tHatch.getTierForStructure() < this.tier()) {
            return false;
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatches.add(tHatch);
    }

    public abstract Block getCasing();

    public abstract int getCasingMeta();

    public abstract Block getFusionCoil();

    public abstract int getFusionCoilMeta();

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build(), this.getTextureOverlay()};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(52)};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build()};
    }

    public abstract ITexture getTextureOverlay();

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int overclock(int mStartEnergy) {
        if (this.tierOverclock() == 1) {
            return 0;
        }
        if (this.tierOverclock() == 2) {
            return mStartEnergy <= 160000000 ? 1 : 0;
        }
        if (this.tierOverclock() == 4) {
            return mStartEnergy <= 160000000 ? 2 : (mStartEnergy <= 320000000 ? 1 : 0);
        }
        return mStartEnergy <= 160000000 ? 3 : (mStartEnergy <= 320000000 ? 2 : (mStartEnergy <= 640000000 ? 1 : 0));
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sFusionRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected GT_ParallelHelper createParallelHelper(@NotNull GT_Recipe recipe) {
                return super.createParallelHelper(recipe).setConsumption(!GT_MetaTileEntity_FusionComputer.this.mRunningOnLoad);
            }

            @Override
            @NotNull
            protected GT_OverclockCalculator createOverclockCalculator(@NotNull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).limitOverclockCount(GT_MetaTileEntity_FusionComputer.this.overclock(recipe.mSpecialValue));
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (!GT_MetaTileEntity_FusionComputer.this.mRunningOnLoad && (long)recipe.mSpecialValue > GT_MetaTileEntity_FusionComputer.this.maxEUStore()) {
                    return CheckRecipeResultRegistry.insufficientStartupPower(recipe.mSpecialValue);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (GT_MetaTileEntity_FusionComputer.this.mRunningOnLoad) {
                    GT_MetaTileEntity_FusionComputer.this.mRunningOnLoad = false;
                }
                GT_MetaTileEntity_FusionComputer.this.turnCasingActive(result.wasSuccessful());
                GT_MetaTileEntity_FusionComputer.this.mLastRecipe = result.wasSuccessful() ? this.lastRecipe : null;
                return result;
            }
        }.setOverclock(1, 1);
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GT_Values.V[this.tier()]);
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(false);
    }

    public abstract int tierOverclock();

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mEnergyHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mOutputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (GT_MetaTileEntity_Hatch hatch : this.mInputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad && this.checkMachine(aBaseMetaTileEntity, this.mInventory[1])) {
                this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                this.checkRecipe();
            }
            if (this.mUpdated) {
                this.mUpdate = 50;
                this.mUpdated = false;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.checkStructure(true, aBaseMetaTileEntity);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                    if (this.mEnergyHatches != null) {
                        for (GT_MetaTileEntity_Hatch_Energy tHatch : GT_Utility.filterValidMTEs(this.mEnergyHatches)) {
                            long energyToMove = GT_Values.V[this.tier()] / 16L;
                            if (aBaseMetaTileEntity.getStoredEU() + energyToMove >= this.maxEUStore() || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(energyToMove, false)) continue;
                            aBaseMetaTileEntity.increaseStoredEnergyUnits(energyToMove, true);
                        }
                    }
                    if (this.mEUStore <= 0L && this.mMaxProgresstime > 0) {
                        this.criticalStopMachine();
                    }
                    if (this.mMaxProgresstime > 0) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(-this.mEUt, true);
                        if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                            if (this.mOutputItems != null) {
                                for (ItemStack itemStack : this.mOutputItems) {
                                    if (itemStack == null) continue;
                                    this.addOutput(itemStack);
                                }
                            }
                            if (this.mOutputFluids != null) {
                                for (ItemStack itemStack : this.mOutputFluids) {
                                    if (itemStack == null) continue;
                                    this.addOutput((FluidStack)itemStack);
                                }
                            }
                            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1])));
                            this.mOutputItems = null;
                            this.mProgresstime = 0;
                            this.mMaxProgresstime = 0;
                            this.mEfficiencyIncrease = 0;
                            if (this.mOutputFluids != null && this.mOutputFluids.length > 0) {
                                try {
                                    GT_Mod.achievements.issueAchivementHatchFluid(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), this.mOutputFluids[0]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe();
                            }
                        }
                    } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                        this.turnCasingActive(this.mMaxProgresstime > 0);
                        if (aBaseMetaTileEntity.isAllowedToWork()) {
                            this.mEUStore = aBaseMetaTileEntity.getStoredEU();
                            if (this.checkRecipe()) {
                                if (this.mEUStore < (long)(this.mLastRecipe.mSpecialValue + this.mEUt)) {
                                    this.criticalStopMachine();
                                }
                                aBaseMetaTileEntity.decreaseStoredEnergyUnits(this.mLastRecipe.mSpecialValue + this.mEUt, true);
                            }
                        }
                        if (this.mMaxProgresstime <= 0) {
                            this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                        }
                    }
                } else {
                    this.mLastRecipe = null;
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        }
    }

    @Override
    public boolean drainEnergyInput(long aEU) {
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void stopMachine() {
        super.stopMachine();
        this.turnCasingActive(false);
    }

    @Override
    public String[] getInfoData() {
        String tier = this.tier() == 6 ? EnumChatFormatting.RED + "I" + EnumChatFormatting.RESET : (this.tier() == 7 ? EnumChatFormatting.YELLOW + "II" + EnumChatFormatting.RESET : (this.tier() == 8 ? EnumChatFormatting.GRAY + "III" + EnumChatFormatting.RESET : "IV"));
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{EnumChatFormatting.BLUE + "Fusion Reactor MK " + EnumChatFormatting.RESET + tier, StatCollector.func_74838_a((String)"GT5U.fusion.req") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(powerRequired) + EnumChatFormatting.RESET + "EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mEUStore) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.maxEUStore()) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.fusion.plasma") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(plasmaOut) + EnumChatFormatting.RESET + "L/t"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 7, 1, 12);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 1, 12, elementBudget, env, false, true);
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GT_MACHINES_FUSION_LOOP;
    }

    @Override
    public boolean doesBindPlayerInventory() {
        return false;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(155, 145));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return new GUITextureSet().setMainBackground(GT_UITextures.BACKGROUND_FUSION_COMPUTER);
    }

    @Override
    public int getGUIWidth() {
        return 176;
    }

    @Override
    public int getGUIHeight() {
        return 166;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget(GT_Utility.trans("138", "Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine).setPos(10, 8))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }))).widget(new TextWidget("Hit with Soft Mallet to (re-)start the Machine if it doesn't start.").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.Center).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && !this.getBaseMetaTileEntity().isActive()).setPos(-this.getGUIWidth() / 2, 170).setSize(this.getGUIWidth() * 2, 9))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.getBaseMetaTileEntity().isActive(), val -> this.getBaseMetaTileEntity().setActive((boolean)val)))).widget(new TextWidget("Running perfectly.").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.Center).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()).setPos(0, 170).setSize(this.getGUIWidth(), 9))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.getBaseMetaTileEntity().getErrorDisplayID(), val -> this.getBaseMetaTileEntity().setErrorDisplayID((int)val)))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.getBaseMetaTileEntity().getStoredEU() / (float)this.getBaseMetaTileEntity().getEUCapacity())).setDirection(ProgressBar.Direction.RIGHT).setTexture(GT_UITextures.PROGRESSBAR_STORED_EU, 147).setPos(5, 156).setSize(147, 5))).widget(TextWidget.dynamicString(() -> {
            long energy = this.getBaseMetaTileEntity().getStoredEU();
            if (energy > 160000000L && energy < 160010000L) {
                energy = 160000000L;
            }
            if (energy > 320000000L && energy < 320010000L) {
                energy = 320000000L;
            }
            if (energy > 640000000L && energy < 640010000L) {
                energy = 640000000L;
            }
            if (energy > 5120000000L && energy < 5120080000L) {
                energy = 5120000000L;
            }
            return GT_Utility.formatNumbers(energy) + " EU";
        }).setDefaultColor(((Integer)this.COLOR_TEXT_RED.get()).intValue()).setPos(50, 155))).widget(new ButtonWidget().setNEITransferRect(GT_Recipe.GT_Recipe_Map.sFusionRecipes.mNEIName).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD, GT_UITextures.OVERLAY_BUTTON_NEI}).setPos(154, 4).setSize(18, 18));
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public Set<VoidingMode> getAllowedVoidingModes() {
        return VoidingMode.FLUID_ONLY_MODES;
    }

    static {
        Textures.BlockIcons.setCasingTextureForId(52, TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW_GLOW).extFacing().glow().build()));
    }
}

