/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.util;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLocation {
    public final IBlockAccess blockAccess;
    public final World world;
    public final int x;
    public final int y;
    public final int z;
    private final boolean isWorld;

    private BlockLocation(IBlockAccess blockAccess, World world, int x, int y, int z, boolean isWorld) {
        this.blockAccess = blockAccess;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isWorld = isWorld;
    }

    public static BlockLocation get(IBlockAccess blockAccess, int x, int y, int z) {
        return new BlockLocation(blockAccess, null, x, y, z, false);
    }

    public static BlockLocation get(World world, int x, int y, int z) {
        return new BlockLocation((IBlockAccess)world, world, x, y, z, true);
    }

    public static BlockLocation get(TileEntity tileEntity) {
        return BlockLocation.get(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public BlockLocation relative(int x, int y, int z) {
        return new BlockLocation(this.blockAccess, this.world, this.x + x, this.y + y, this.z + z, this.isWorld);
    }

    public BlockLocation offset(ForgeDirection direction, int distance) {
        return this.relative(direction.offsetX * distance, direction.offsetY * distance, direction.offsetZ * distance);
    }

    public BlockLocation neighbor(ForgeDirection direction) {
        return this.relative(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public BlockLocation west() {
        return this.neighbor(ForgeDirection.WEST);
    }

    public BlockLocation east() {
        return this.neighbor(ForgeDirection.EAST);
    }

    public BlockLocation below() {
        return this.neighbor(ForgeDirection.DOWN);
    }

    public BlockLocation above() {
        return this.neighbor(ForgeDirection.UP);
    }

    public BlockLocation north() {
        return this.neighbor(ForgeDirection.NORTH);
    }

    public BlockLocation south() {
        return this.neighbor(ForgeDirection.SOUTH);
    }

    public Block getBlock() {
        return this.blockAccess.func_147439_a(this.x, this.y, this.z);
    }

    public int getMetadata() {
        return this.blockAccess.func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity() {
        return this.blockAccess.func_147438_o(this.x, this.y, this.z);
    }

    public <T extends TileEntity> T getTileEntity(Class<T> tileEntityClass) {
        TileEntity tileEntity = this.getTileEntity();
        return (T)(tileEntityClass.isInstance(tileEntity) ? tileEntity : null);
    }

    public <T extends TileEntity> T getTileEntityStrict(Class<T> tileEntityClass) {
        TileEntity tileEntity = this.getTileEntity();
        if (tileEntity == null) {
            throw new Error(String.format("Expected tile entity at %s, but none found.", this));
        }
        if (!tileEntityClass.isInstance(tileEntity)) {
            throw new Error(String.format("Expected tile entity at %s to be '%s', but found '%s' instead.", this, tileEntityClass.getName(), tileEntity.getClass().getName()));
        }
        return (T)tileEntity;
    }

    public void setBlock(Block block) {
        if (this.isWorld) {
            this.world.func_147449_b(this.x, this.y, this.z, block);
        }
    }

    public void setMetadata(int metadata) {
        if (this.isWorld) {
            this.world.func_72921_c(this.x, this.y, this.z, metadata, 3);
        }
    }

    public void setBlockAndMetadata(Block block, int metadata) {
        if (this.isWorld) {
            this.world.func_147465_d(this.x, this.y, this.z, block, metadata, 3);
        }
    }

    public void setTileEntity(TileEntity tileEntity) {
        if (this.isWorld) {
            this.world.func_147455_a(this.x, this.y, this.z, tileEntity);
        }
    }

    public boolean isAir() {
        return this.blockAccess.func_147437_c(this.x, this.y, this.z);
    }

    public boolean isReplaceable() {
        return this.getBlock().isReplaceable(this.blockAccess, this.x, this.y, this.z);
    }

    public boolean isSideSolid(ForgeDirection side) {
        return this.blockAccess.isSideSolid(this.x, this.y, this.z, side, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockLocation)) return false;
        BlockLocation loc = (BlockLocation)obj;
        if (this.blockAccess != loc.blockAccess) return false;
        if (this.x != loc.x) return false;
        if (this.y != loc.y) return false;
        if (this.z != loc.z) return false;
        return true;
    }

    public int hashCode() {
        return this.blockAccess.hashCode() ^ this.x ^ this.z << 4 ^ this.y << 8;
    }

    public String toString() {
        return String.format("[%s; Coords=%s,%s,%s]", this.getWorldName(), this.x, this.y, this.z);
    }

    private String getWorldName() {
        return this.isWorld ? "DIM=" + Integer.toString(this.world.field_73011_w.field_76574_g) : this.blockAccess.toString();
    }
}

