/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.items.ItemArcanePackage;
import makeo.gadomancy.common.items.ItemAuraCore;
import makeo.gadomancy.common.items.ItemCreativeNode;
import makeo.gadomancy.common.items.ItemElement;
import makeo.gadomancy.common.items.ItemExtendedNodeJar;
import makeo.gadomancy.common.items.ItemFakeGolemPlacer;
import makeo.gadomancy.common.items.ItemFakeGolemShield;
import makeo.gadomancy.common.items.ItemFakeLootbag;
import makeo.gadomancy.common.items.ItemFakeModIcon;
import makeo.gadomancy.common.items.ItemGolemCoreBreak;
import makeo.gadomancy.common.items.ItemTransformationFocus;
import makeo.gadomancy.common.items.baubles.ItemEtherealFamiliar;
import makeo.gadomancy.common.items.baubles.ItemFamiliar_Old;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.research.SimpleResearchItem;
import makeo.gadomancy.common.utils.Injector;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.EnumHelper;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.research.ResearchManager;

public class RegisteredItems {
    public static EnumRarity raritySacred = EnumHelper.addRarity((String)"Sacred", (EnumChatFormatting)EnumChatFormatting.GOLD, (String)"Sacred");
    public static CreativeTabs creativeTab;
    public static ItemFakeModIcon itemFakeModIcon;
    public static ItemFakeGolemShield itemFakeGolemShield;
    public static ItemFakeGolemPlacer itemFakeGolemPlacer;
    public static ItemTransformationFocus itemTransformationFocus;
    public static ItemGolemCoreBreak itemGolemCoreBreak;
    public static ItemExtendedNodeJar itemExtendedNodeJar;
    public static ItemFamiliar_Old itemFamiliar_old;
    public static ItemEtherealFamiliar itemEtherealFamiliar;
    public static ItemCreativeNode itemCreativeNode;
    public static ItemArcanePackage itemPackage;
    public static ItemFakeLootbag itemFakeLootbag;
    public static ItemAuraCore itemAuraCore;
    public static ItemElement itemElement;
    private static List<StickyJarItemInfo> stickyJarItems;

    private RegisteredItems() {
    }

    public static void preInit() {
        creativeTab = new CreativeTabs("gadomancy"){

            public Item func_78016_d() {
                return itemFakeModIcon;
            }
        };
    }

    public static void init() {
        RegisteredItems.registerItems();
        RegisteredItems.registerDefaultStickyJars();
    }

    public static void postInit() {
        RegisteredItems.registerItemAspects();
    }

    private static void registerItems() {
        itemTransformationFocus = RegisteredItems.registerItem(new ItemTransformationFocus());
        itemGolemCoreBreak = RegisteredItems.registerItem(new ItemGolemCoreBreak());
        itemFamiliar_old = RegisteredItems.registerItem(new ItemFamiliar_Old(), "ItemFamiliar");
        itemEtherealFamiliar = RegisteredItems.registerItem(new ItemEtherealFamiliar());
        itemAuraCore = RegisteredItems.registerItem(new ItemAuraCore());
        itemElement = RegisteredItems.registerItem(new ItemElement());
        itemCreativeNode = RegisteredItems.registerItem(new ItemCreativeNode());
        itemPackage = RegisteredItems.registerItem(new ItemArcanePackage());
        itemFakeLootbag = RegisteredItems.registerItem("Thaumcraft", new ItemFakeLootbag());
        itemFakeGolemPlacer = RegisteredItems.registerItem(new ItemFakeGolemPlacer());
        itemFakeGolemShield = RegisteredItems.registerItem(new ItemFakeGolemShield());
        itemExtendedNodeJar = RegisteredItems.registerItem(new ItemExtendedNodeJar());
        itemFakeModIcon = RegisteredItems.registerItem(new ItemFakeModIcon());
    }

    private static <T extends Item> T registerItem(T item, String name) {
        GameRegistry.registerItem(item, (String)name);
        return item;
    }

    private static <T extends Item> T registerItem(T item) {
        return RegisteredItems.registerItem(item, item.getClass().getSimpleName());
    }

    private static <T extends Item> T registerItem(String modId, T item) {
        return RegisteredItems.registerItem(modId, item, item.getClass().getSimpleName());
    }

    private static <T extends Item> T registerItem(String modId, T item, String name) {
        Injector modController = new Injector(new Injector(Loader.instance(), Loader.class).getField("modController"), LoadController.class);
        Object old = modController.getField("activeContainer");
        modController.setField("activeContainer", Loader.instance().getIndexedModList().get(modId));
        GameRegistry.registerItem(item, (String)name);
        modController.setField("activeContainer", old);
        return item;
    }

    private static void registerItemAspects() {
        AspectList oldAspects = ThaumcraftCraftingManager.getObjectTags((ItemStack)new ItemStack((Block)RegisteredBlocks.blockStoneMachine));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Item.func_150898_a((Block)RegisteredBlocks.blockStoneMachine)), (int[])new int[]{11, 15}, (AspectList)new AspectList());
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Item.func_150898_a((Block)RegisteredBlocks.blockStoneMachine)), (int[])new int[]{0}, (AspectList)oldAspects);
        AspectList pylon = new AspectList().add(Aspect.WATER, 10).add(Aspect.MAGIC, 12).add(Aspect.VOID, 4).add(Aspect.MECHANISM, 4);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Item.func_150898_a((Block)RegisteredBlocks.blockAuraPylon)), (int[])new int[]{0}, (AspectList)pylon);
        pylon = new AspectList().add(Aspect.FIRE, 10).add(Aspect.AURA, 12).add(Aspect.MAGIC, 8).add(Aspect.LIGHT, 4).add(Aspect.MECHANISM, 4);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Item.func_150898_a((Block)RegisteredBlocks.blockAuraPylon)), (int[])new int[]{1}, (AspectList)pylon);
        AspectList packager = new AspectList().add(Aspect.TREE, 10).add(Aspect.MECHANISM, 8).add(Aspect.CRAFT, 8).add(Aspect.AURA, 12);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Item.func_150898_a((Block)RegisteredBlocks.blockStoneMachine)), (int[])new int[]{4}, (AspectList)packager);
        AspectList aspect = new AspectList();
        aspect.add(Aspect.MAGIC, 6).add(Aspect.AURA, 12).add(Aspect.ELDRITCH, 4).add(Aspect.VOID, 10);
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemAuraCore), (int[])new int[]{0}, (AspectList)aspect.copy());
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemAuraCore), (int[])new int[]{1}, (AspectList)aspect.copy().add(Aspect.AIR, 26));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemAuraCore), (int[])new int[]{2}, (AspectList)aspect.copy().add(Aspect.FIRE, 26));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemAuraCore), (int[])new int[]{3}, (AspectList)aspect.copy().add(Aspect.WATER, 26));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemAuraCore), (int[])new int[]{4}, (AspectList)aspect.copy().add(Aspect.EARTH, 26));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemAuraCore), (int[])new int[]{5}, (AspectList)aspect.copy().add(Aspect.ORDER, 26));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemAuraCore), (int[])new int[]{6}, (AspectList)aspect.copy().add(Aspect.ENTROPY, 26));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemPackage, 1, 0), (AspectList)new AspectList().add(Aspect.CLOTH, 2).add(Aspect.BEAST, 2).add(Aspect.ARMOR, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemPackage, 1, 1), (AspectList)new AspectList().add(Aspect.CLOTH, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemFakeLootbag, 1, 0), (AspectList)new AspectList().add(Aspect.CLOTH, 2).add(Aspect.BEAST, 2).add(Aspect.ARMOR, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Item)itemFakeLootbag, 1, 1), (AspectList)new AspectList().add(Aspect.CLOTH, 4));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Block)RegisteredBlocks.blockKnowledgeBook), (AspectList)new AspectList().add(Aspect.MIND, 8).add(Aspect.MECHANISM, 4).add(Aspect.MAGIC, 6).add(Aspect.ORDER, 4));
    }

    private static void registerDefaultStickyJars() {
        RegisteredItems.registerStickyJar(ConfigItems.itemJarFilled, 0);
        RegisteredItems.registerStickyJar(ConfigItems.itemJarFilled, 3);
        Item itemBlockJar = Item.func_150898_a((Block)ConfigBlocks.blockJar);
        RegisteredItems.registerStickyJar(itemBlockJar, 0, new ItemStack(itemBlockJar, 1, 0), "JARLABEL");
        RegisteredItems.registerStickyJar(itemBlockJar, 3, new ItemStack(itemBlockJar, 1, 3), "JARVOID");
        Item itemRemoteJar = Item.func_150898_a((Block)RegisteredBlocks.blockRemoteJar);
        RegisteredItems.registerStickyJar(itemRemoteJar, 0, new ItemStack(itemRemoteJar), SimpleResearchItem.getFullName("REMOTEJAR"));
    }

    public static void registerStickyJar(Item item, int damage, ItemStack recipeStack) {
        RegisteredItems.registerStickyJar(item, damage, recipeStack, null);
    }

    public static void registerStickyJar(Item item, int damage, ItemStack recipeStack, String research) {
        StickyJarItemInfo info = new StickyJarItemInfo();
        info.item = item;
        info.damage = damage;
        info.recipeStack = recipeStack;
        info.research = research;
        stickyJarItems.add(info);
    }

    public static void registerStickyJar(Item item, int damage) {
        RegisteredItems.registerStickyJar(item, damage, null);
    }

    public static void registerStickyJar(Item item) {
        RegisteredItems.registerStickyJar(item, Short.MAX_VALUE);
    }

    public static boolean isStickyableJar(Item item, int damage) {
        for (StickyJarItemInfo info : stickyJarItems) {
            if (info.item != item || info.damage != damage && info.damage != Short.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    public static boolean isStickyableJar(ItemStack stack) {
        return stack != null && RegisteredItems.isStickyableJar(stack.func_77973_b(), stack.func_77960_j());
    }

    public static List<ItemStack> getStickyJarStacks() {
        return RegisteredItems.getStickyJarStacks(null);
    }

    public static List<ItemStack> getStickyJarStacks(EntityPlayer player) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (StickyJarItemInfo info : stickyJarItems) {
            if (info.recipeStack == null || player != null && info.research != null && !ResearchManager.isResearchComplete((String)player.func_70005_c_(), (String)info.research)) continue;
            stacks.add(info.recipeStack);
        }
        return stacks;
    }

    static {
        stickyJarItems = new ArrayList<StickyJarItemInfo>();
    }

    private static class StickyJarItemInfo {
        public Item item;
        public int damage;
        public ItemStack recipeStack;
        public String research;

        private StickyJarItemInfo() {
        }
    }
}

