/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import cpw.mods.fml.common.Loader;
import makeo.gadomancy.common.Gadomancy;
import makeo.gadomancy.common.integration.IntegrationAutomagy;
import makeo.gadomancy.common.integration.IntegrationMod;
import makeo.gadomancy.common.integration.IntegrationMorph;
import makeo.gadomancy.common.integration.IntegrationNEI;
import makeo.gadomancy.common.integration.IntegrationThaumicExploration;
import makeo.gadomancy.common.integration.IntegrationThaumicTinkerer;
import makeo.gadomancy.common.integration.mystcraft.IntegrationMystcraft;
import makeo.gadomancy.common.utils.Injector;

public class RegisteredIntegrations {
    public static IntegrationMorph morph;
    public static IntegrationThaumicExploration thaumicExploration;
    public static IntegrationAutomagy automagy;
    public static IntegrationNEI nei;
    public static IntegrationMystcraft mystcraft;
    public static IntegrationThaumicTinkerer thaumicTinkerer;

    private RegisteredIntegrations() {
    }

    public static void init() {
        morph = RegisteredIntegrations.registerIndependent(IntegrationMorph.class);
        thaumicExploration = RegisteredIntegrations.registerIndependent(IntegrationThaumicExploration.class);
        automagy = RegisteredIntegrations.registerIndependent(IntegrationAutomagy.class);
        nei = RegisteredIntegrations.registerIndependent(IntegrationNEI.class);
        mystcraft = RegisteredIntegrations.registerIndependent(IntegrationMystcraft.class);
        thaumicTinkerer = RegisteredIntegrations.registerIndependent(IntegrationThaumicTinkerer.class);
        RegisteredIntegrations.registerDependent("ThaumicHorizons", "makeo.gadomancy.common.integration.thaumichorizions.IntegrationThaumicHorizions");
        RegisteredIntegrations.registerDependent("Waila", "makeo.gadomancy.common.integration.waila.IntegrationWaila");
    }

    private static void registerDependent(String modId, String clazz) {
        Object integration;
        if (!Loader.isModLoaded((String)modId)) {
            return;
        }
        try {
            integration = Injector.getClass(clazz).newInstance();
        }
        catch (Throwable e) {
            return;
        }
        if (integration instanceof IntegrationMod) {
            ((IntegrationMod)integration).init();
        }
    }

    private static <T extends IntegrationMod> T registerIndependent(Class<T> clazz) {
        IntegrationMod integration;
        try {
            integration = (IntegrationMod)clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        integration.init();
        if (integration.isPresent()) {
            Gadomancy.log.info("Initialized hook for mod \"" + integration.getModId() + "\"!");
        }
        return (T)integration;
    }
}

