/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityInfiniteFluid
extends TileEntity
implements IFluidHandler,
IFluidTank {
    public static final int SINGLE_FLUID = 0;
    public static final int SUPPLY_ALL_FLUIDS = 1;
    private boolean needsUpdate = false;
    private int updateTimer = 0;
    public FluidStack fluid = null;
    public int mode = 0;

    public int changeMode() {
        this.mode = this.mode == 0 ? 1 : 0;
        return this.mode;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public int fill(FluidStack resource, boolean doFill) {
        switch (this.mode) {
            case 0: {
                if (this.fluid == null) {
                    if (doFill) {
                        this.fluid = resource.copy();
                        this.fluid.amount = this.getCapacity();
                        this.needsUpdate = true;
                        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, resource.amount));
                    }
                    return resource.amount;
                }
                if (this.fluid.isFluidEqual(resource)) {
                    if (doFill) {
                        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, resource.amount));
                    }
                    return resource.amount;
                }
                return 0;
            }
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        switch (this.mode) {
            case 0: {
                if (this.fluid == null) {
                    return null;
                }
                if (!this.fluid.isFluidEqual(resource)) break;
                if (doDrain) {
                    FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, resource.amount));
                }
                return resource.copy();
            }
            case 1: {
                if (doDrain) {
                    FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, resource.amount));
                }
                return resource.copy();
            }
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        FluidStack fs = this.fluid.copy();
        fs.amount = maxDrain;
        if (doDrain) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, 0));
        }
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.mode == 0 && this.fluid == null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.mode == 0) {
            return this.fluid != null && this.fluid.getFluid() == fluid;
        }
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    public void func_145845_h() {
        if (this.needsUpdate) {
            ++this.updateTimer;
            this.updateTimer %= 10;
            if (this.updateTimer == 0) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.needsUpdate = false;
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.fluid = tag.func_74764_b("Empty") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        this.mode = tag.func_74762_e("mode") == 1 ? 1 : 0;
        super.func_145839_a(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        if (this.fluid == null) {
            tag.func_74757_a("Empty", true);
        } else {
            this.fluid.writeToNBT(tag);
        }
        tag.func_74768_a("mode", this.mode);
        super.func_145841_b(tag);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public void setFluid(FluidStack fluid) {
        if (fluid == null) {
            this.fluid = null;
        } else {
            this.fluid = fluid.copy();
            this.fluid.amount = this.getCapacity();
        }
        this.needsUpdate = true;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid == null ? 0 : this.getCapacity();
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

