/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.auxiliary;

import cpw.mods.fml.common.registry.GameRegistry;
import galacticgreg.GalacticGreg;
import galacticgreg.api.BlockMetaComb;
import galacticgreg.auxiliary.ConfigManager;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class GalacticGregConfig
extends ConfigManager {
    public boolean ProfileOreGen;
    public boolean ReportOreGenFailures;
    public boolean PrintDebugMessagesToFMLLog;
    public boolean PrintTraceMessagesToFMLLog;
    public boolean LootChestsEnabled;
    public boolean EnableAEExportCommand;
    public boolean SchematicsEnabled;
    public String LootChestItemOverride;
    public boolean QuietMode;
    public BlockMetaComb CustomLootChest;

    public GalacticGregConfig(File pConfigBaseDirectory, String pModCollectionDirectory, String pModID) {
        super(pConfigBaseDirectory, pModCollectionDirectory, pModID);
    }

    @Override
    protected void PreInit() {
        this.ProfileOreGen = false;
        this.ReportOreGenFailures = false;
        this.PrintDebugMessagesToFMLLog = false;
        this.PrintTraceMessagesToFMLLog = false;
        this.LootChestsEnabled = true;
        this.EnableAEExportCommand = false;
        this.SchematicsEnabled = false;
        this.LootChestItemOverride = "";
        this.QuietMode = false;
    }

    @Override
    protected void Init() {
        this.ProfileOreGen = this._mainConfig.getBoolean("ProfileOreGen", "Debug", this.ProfileOreGen, "Enable to profile oregen and register the ingame command ggregprofiler");
        this.ReportOreGenFailures = this._mainConfig.getBoolean("ReportOreGenFailures", "Debug", this.ReportOreGenFailures, "Report if a ore tileentity could not be placed");
        this.PrintDebugMessagesToFMLLog = this._mainConfig.getBoolean("PrintDebugMessagesToFMLLog", "Debug", this.PrintDebugMessagesToFMLLog, "Enable debug output, not recommended for servers");
        this.PrintTraceMessagesToFMLLog = this._mainConfig.getBoolean("PrintTraceMessagesToFMLLog", "Debug", this.PrintTraceMessagesToFMLLog, "Enable trace output. Warning: This will produce gazillions of log entries");
        this.QuietMode = this._mainConfig.getBoolean("QuietMode", "Debug", this.QuietMode, "In quiet-mode only errors, warnings and fatals will be printed to the logfile/console");
        this.LootChestsEnabled = this._mainConfig.getBoolean("LootChestsEnabled", "Extras", this.LootChestsEnabled, "Enables/disables the dungeon-chest generator system for asteroids. New config values will be generated if set to true");
        this.EnableAEExportCommand = this._mainConfig.getBoolean("EnableAEExportCommand", "Extras", this.EnableAEExportCommand, "If set to true, you can export any structure stored on a AE2 spatial storage disk. (Can't be spawned yet, WiP). Requires SchematicsEnabled to be true");
        this.SchematicsEnabled = this._mainConfig.getBoolean("SchematicsEnabled", "Extras", this.SchematicsEnabled, "Enable the experimental Schematics-handler to spawn exported schematics in dimensions. This is WiP, use at own risk");
        this.LootChestItemOverride = this._mainConfig.getString("CustomLootChest", "Extras", this.LootChestItemOverride, "Define the chest you wish to use as LootChest. use the <ModID>:<Name>:<meta> format or leave empty for the default Minecraft Chest");
        GalacticGreg.Logger.setDebugOutput(this.PrintDebugMessagesToFMLLog);
        GalacticGreg.Logger.setTraceOutput(this.PrintTraceMessagesToFMLLog);
        GalacticGreg.Logger.setQuietMode(this.QuietMode);
    }

    @Override
    protected void PostInit() {
    }

    public boolean serverPostInit() {
        this.CustomLootChest = new BlockMetaComb((Block)Blocks.field_150486_ae);
        try {
            String[] args;
            if (this.LootChestItemOverride != null && !this.LootChestItemOverride.isEmpty() && (args = this.LootChestItemOverride.split(":")).length >= 2) {
                String tMod = args[0];
                String tName = args[1];
                int tMeta = args.length == 3 ? Integer.parseInt(args[2]) : 0;
                Block tBlock = GameRegistry.findBlock((String)tMod, (String)tName);
                if (tBlock != null) {
                    GalacticGreg.Logger.debug("Found valid ChestOverride: %s. LootChest replaced", this.LootChestItemOverride);
                    this.CustomLootChest = new BlockMetaComb(tBlock, tMeta);
                }
            }
            return true;
        }
        catch (Exception e) {
            GalacticGreg.Logger.error("Unable to find custom chest override %s. Make sure item exists. Defaulting to Minecraft:chest", this.LootChestItemOverride);
            e.printStackTrace();
            return false;
        }
    }
}

