/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.mail.network.packets.PacketPOBoxInfoUpdate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class PostalCarrier
implements IPostalCarrier {
    private final String iconID;
    private final EnumAddressee type;

    public PostalCarrier(EnumAddressee type) {
        this.iconID = "mail/carrier." + (Object)((Object)type);
        this.type = type;
    }

    @Override
    public EnumAddressee getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return StringUtil.localize("gui.addressee." + (Object)((Object)this.type));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return TextureManager.getInstance().getDefault(this.iconID);
    }

    @Override
    public IPostalState deliverLetter(World world, IPostOffice office, IMailAddress recipient, ItemStack letterStack, boolean doDeliver) {
        if (this.type == EnumAddressee.TRADER) {
            return PostalCarrier.handleTradeLetter(world, recipient, letterStack, doDeliver);
        }
        return PostalCarrier.storeInPOBox(world, recipient, letterStack);
    }

    private static IPostalState handleTradeLetter(World world, IMailAddress recipient, ItemStack letterStack, boolean doLodge) {
        ITradeStation trade = PostManager.postRegistry.getTradeStation(world, recipient);
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        return trade.handleLetter(world, recipient, letterStack, doLodge);
    }

    private static EnumDeliveryState storeInPOBox(World world, IMailAddress recipient, ItemStack letterStack) {
        POBox pobox = PostRegistry.getPOBox(world, recipient);
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterStack.func_77946_l())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        EntityPlayer player = PlayerUtil.getPlayer(world, recipient.getPlayerProfile());
        if (player instanceof EntityPlayerMP) {
            Proxies.net.sendToPlayer(new PacketPOBoxInfoUpdate(pobox.getPOBoxInfo()), (EntityPlayer)((EntityPlayerMP)player));
        }
        return EnumDeliveryState.OK;
    }
}

