/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.CentrifugeRecipe;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class CentrifugeRecipeManager
implements ICentrifugeManager {
    private static final Set<ICentrifugeRecipe> recipes = new HashSet<ICentrifugeRecipe>();

    @Override
    public void addRecipe(int timePerItem, ItemStack resource, Map<ItemStack, Float> products) {
        CentrifugeRecipe recipe = new CentrifugeRecipe(timePerItem, resource, products);
        this.addRecipe(recipe);
    }

    public static ICentrifugeRecipe findMatchingRecipe(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        for (ICentrifugeRecipe recipe : recipes) {
            ItemStack recipeInput = recipe.getInput();
            if (!ItemStackUtil.isCraftingEquivalent(recipeInput, itemStack)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean addRecipe(ICentrifugeRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(ICentrifugeRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Set<ICentrifugeRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }

    @Override
    @Deprecated
    public Map<Object[], Object[]> getRecipes() {
        HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
        for (ICentrifugeRecipe recipe : recipes) {
            Set<ItemStack> productsKeys = recipe.getAllProducts().keySet();
            recipeList.put(new Object[]{recipe.getInput()}, productsKeys.toArray(new ItemStack[productsKeys.size()]));
        }
        return recipeList;
    }
}

