/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.utils;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MoveGen;
import com.jamesswafford.chess4j.board.Undo;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.pieces.Bishop;
import com.jamesswafford.chess4j.pieces.Knight;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.pieces.Queen;
import com.jamesswafford.chess4j.pieces.Rook;
import com.jamesswafford.chess4j.utils.GameStatus;
import java.util.List;

public final class GameStatusChecker {
    private GameStatusChecker() {
    }

    public static GameStatus getGameStatus() {
        Board b = Board.INSTANCE;
        List<Move> moves = MoveGen.genLegalMoves(b);
        if (moves.size() == 0) {
            if (b.isPlayerInCheck()) {
                return GameStatus.CHECKMATED;
            }
            return GameStatus.STALEMATED;
        }
        if (GameStatusChecker.isLackOfMatingMaterial(b)) {
            return GameStatus.DRAW_MATERIAL;
        }
        if (GameStatusChecker.isDrawByRep(b)) {
            return GameStatus.DRAW_REP;
        }
        if (b.getFiftyCounter() >= 100) {
            return GameStatus.DRAW_BY_50;
        }
        return GameStatus.INPROGRESS;
    }

    private static boolean isLackOfMatingMaterial(Board b) {
        int numKnights = 0;
        int numWhiteSqBishops = 0;
        int numBlackSqBishops = 0;
        List<Square> squares = Square.allSquares();
        for (Square sq : squares) {
            Piece p = b.getPiece(sq);
            if (p instanceof Pawn || p instanceof Rook || p instanceof Queen) {
                return false;
            }
            if (p instanceof Knight) {
                ++numKnights;
            }
            if (!(p instanceof Bishop)) continue;
            if (sq.isLight()) {
                ++numWhiteSqBishops;
                continue;
            }
            ++numBlackSqBishops;
        }
        return !GameStatusChecker.canMateWithMinors(numKnights, numWhiteSqBishops, numBlackSqBishops);
    }

    private static boolean canMateWithMinors(int numKnights, int numWhiteSqBishops, int numDarkSqBishops) {
        if (numKnights > 0) {
            if (numKnights > 1) {
                return true;
            }
            if (numWhiteSqBishops > 0 || numDarkSqBishops > 0) {
                return true;
            }
        }
        return numWhiteSqBishops > 0 && numDarkSqBishops > 0;
    }

    public static int getNumberPreviousVisits(Board b) {
        int visits = 0;
        long currentZobristKey = b.getZobristKey();
        List<Undo> undos = b.getUndos();
        for (Undo undo : undos) {
            if (undo.getZobristKey() != currentZobristKey) continue;
            ++visits;
        }
        return visits;
    }

    public static boolean isDrawByRep(Board b) {
        int numPrevVisits = GameStatusChecker.getNumberPreviousVisits(b);
        return numPrevVisits >= 2;
    }
}

