/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.common.building.ArchitectureCraftAnalysisResult;
import com.recursive_pineapple.matter_manipulator.common.building.CopyableProperty;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.BlockPropertyRegistry;
import com.recursive_pineapple.matter_manipulator.common.compat.IntrinsicProperty;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemId;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.common.registry.GameRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockSpec
implements ImmutableBlockSpec {
    public static final GameRegistry.UniqueIdentifier AIR_ID = new GameRegistry.UniqueIdentifier("minecraft:air");
    @SerializedName(value="b")
    private boolean isBlock;
    @SerializedName(value="id")
    private GameRegistry.UniqueIdentifier objectId;
    @SerializedName(value="m")
    private int metadata;
    @SerializedName(value="p")
    public Map<CopyableProperty, String> properties;
    @SerializedName(value="a")
    @com.recursive_pineapple.matter_manipulator.asm.Optional(value={"ArchitectureCraft"})
    public ArchitectureCraftAnalysisResult arch;
    @SerializedName(value="i")
    @Nullable
    public Map<String, JsonElement> intrinsicProperties;
    private transient Block block;
    private transient Optional<Item> item;
    private transient Optional<ItemId> itemId;
    private transient Optional<ItemStack> stack;
    public static final ImmutableBlockSpec AIR = BlockSpec.air();

    public BlockSpec() {
        this.reset();
    }

    private BlockSpec reset() {
        this.isBlock = true;
        this.objectId = AIR_ID;
        this.metadata = 0;
        this.properties = null;
        this.block = null;
        this.item = null;
        this.itemId = null;
        this.stack = null;
        this.intrinsicProperties = null;
        if (Mods.ArchitectureCraft.isModLoaded()) {
            this.arch = null;
        }
        return this;
    }

    public BlockSpec setObject(Block block, int meta) {
        this.reset();
        this.isBlock = true;
        this.objectId = GameRegistry.findUniqueIdentifierFor((Block)block);
        this.metadata = block.func_149692_a(meta);
        this.block = block;
        return this;
    }

    public BlockSpec setObject(ItemStack stack) {
        this.reset();
        this.isBlock = false;
        this.objectId = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b());
        this.metadata = stack.field_77991_e;
        ArrayList<IntrinsicProperty> props = new ArrayList<IntrinsicProperty>();
        BlockPropertyRegistry.getIntrinsicProperties(stack, props);
        if (!props.isEmpty()) {
            this.intrinsicProperties = new Object2ObjectOpenHashMap();
            for (IntrinsicProperty prop : props) {
                this.intrinsicProperties.put(prop.getName(), prop.getValue(stack));
            }
        }
        return this;
    }

    public BlockSpec setObject(Item item, int meta) {
        this.reset();
        this.isBlock = false;
        this.objectId = GameRegistry.findUniqueIdentifierFor((Item)item);
        this.metadata = meta;
        return this;
    }

    public void populate() {
        if (this.isBlock) {
            this.block = GameRegistry.findBlock((String)this.objectId.modId, (String)this.objectId.name);
            this.item = Optional.ofNullable(MMUtils.getItemFromBlock(this.block, this.metadata));
        } else {
            Item item1;
            this.item = Optional.ofNullable(GameRegistry.findItem((String)this.objectId.modId, (String)this.objectId.name));
            this.block = MMUtils.getBlockFromItem(item1, (item1 = (Item)this.item.orElse(null)) == null ? 0 : item1.func_77647_b(this.metadata));
        }
        if (this.block == null) {
            this.block = Blocks.field_150350_a;
        }
    }

    @Override
    public GameRegistry.UniqueIdentifier getObjectId() {
        return this.objectId;
    }

    @Override
    @NotNull
    public Block getBlock() {
        if (this.block == null) {
            this.populate();
        }
        return this.block;
    }

    @Override
    @NotNull
    public Item getItem() {
        ItemStack stack = this.toStack(1);
        return stack == null ? null : stack.func_77973_b();
    }

    public int getItemMeta() {
        ItemStack stack = this.toStack(1);
        return stack == null ? 0 : stack.field_77991_e;
    }

    public int getBlockMeta() {
        return this.getItem() == null ? 0 : this.getItem().func_77647_b(this.getItemMeta());
    }

    public ItemStack toStack(int amount) {
        ItemStack out;
        if (this.stack == null) {
            ItemStack stack = null;
            if (this.isBlock) {
                stack = this.getBlock().func_149644_j(this.metadata);
            }
            if (stack == null || stack.func_77973_b() == null) {
                Item item;
                if (this.item == null) {
                    this.populate();
                }
                if ((item = (Item)this.item.orElse(null)) == null) {
                    this.stack = Optional.empty();
                    return null;
                }
                stack = item.func_77614_k() ? new ItemStack(item, 1, this.metadata) : new ItemStack(item, 1, 0);
            }
            this.stack = stack != null && stack.func_77973_b() != null ? Optional.of(stack) : Optional.empty();
            if (this.stack.isPresent()) {
                ItemStack stack2 = this.stack.get();
                NBTTagCompound tag = new NBTTagCompound();
                stack2.func_77982_d(tag);
                if (Mods.ArchitectureCraft.isModLoaded() && this.arch != null) {
                    this.arch.getItemTag(tag);
                }
                if (this.intrinsicProperties != null) {
                    Object2ObjectOpenHashMap props = new Object2ObjectOpenHashMap();
                    BlockPropertyRegistry.getIntrinsicProperties(stack, (Map<String, IntrinsicProperty>)props);
                    for (Map.Entry<String, JsonElement> e : this.intrinsicProperties.entrySet()) {
                        IntrinsicProperty prop = (IntrinsicProperty)props.get(e.getKey());
                        if (prop == null) {
                            MMMod.LOG.warn("Tried to set intrinsic property '{}' on an item, but the property is not registered to that item. Value='{}' Item='{}'", new Object[]{e.getKey(), e.getValue(), stack.toString(), new Exception()});
                            continue;
                        }
                        prop.setValue(stack, e.getValue());
                    }
                }
                if ((tag = stack2.func_77978_p()) != null && tag.func_82582_d()) {
                    stack2.func_77982_d(null);
                }
            }
        }
        if ((out = ItemStack.func_77944_b((ItemStack)this.stack.orElse(null))) != null) {
            out.field_77994_a *= amount;
        }
        return out;
    }

    @Override
    public void getItemDetails(List<String> details) {
        Object2ObjectOpenHashMap props = new Object2ObjectOpenHashMap();
        BlockPropertyRegistry.getIntrinsicProperties(this.toStack(1), (Map<String, IntrinsicProperty>)props);
        if (this.intrinsicProperties != null) {
            for (Map.Entry<String, JsonElement> e : this.intrinsicProperties.entrySet()) {
                IntrinsicProperty prop = (IntrinsicProperty)props.get(e.getKey());
                if (prop == null) continue;
                prop.getItemDetails(details, e.getValue());
            }
        }
    }

    @Override
    public PendingBlock instantiate(int worldId, int x, int y, int z) {
        PendingBlock pendingBlock = new PendingBlock(worldId, x, y, z, this);
        if (Mods.ArchitectureCraft.isModLoaded() && this.arch != null) {
            pendingBlock.arch = this.arch.clone();
        }
        return pendingBlock;
    }

    public BlockSpec clone() {
        BlockSpec dup = new BlockSpec();
        dup.isBlock = this.isBlock;
        dup.objectId = this.objectId;
        dup.metadata = this.metadata;
        dup.properties = this.properties;
        dup.block = this.block;
        dup.item = this.item;
        dup.itemId = this.itemId;
        dup.stack = this.stack;
        if (Mods.ArchitectureCraft.isModLoaded()) {
            dup.arch = this.arch == null ? null : this.arch.clone();
        }
        return dup;
    }

    @Override
    public String getProperty(CopyableProperty property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get((Object)property);
    }

    @Override
    public BlockSpec withProperties(Map<CopyableProperty, String> properties) {
        if (Objects.equals(properties, this.properties)) {
            return this;
        }
        BlockSpec spec = this.clone();
        spec.properties = properties == null || properties.isEmpty() ? null : new EnumMap<CopyableProperty, String>(properties);
        return spec;
    }

    private String getItemDetails() {
        ArrayList<String> details = new ArrayList<String>(0);
        this.getItemDetails(details);
        if (Mods.ArchitectureCraft.isModLoaded() && this.arch != null) {
            this.arch.getItemDetails(details);
        }
        return details.isEmpty() ? "" : String.format(" (%s)", String.join((CharSequence)", ", details));
    }

    public String getDisplayName() {
        return (this.toStack(1) == null ? Blocks.field_150350_a.func_149732_F() : this.toStack(1).func_82833_r()) + this.getItemDetails();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof BlockSpec)) {
            return false;
        }
        BlockSpec blockSpec = (BlockSpec)o;
        return this.isBlock == blockSpec.isBlock && this.metadata == blockSpec.metadata && this.getBlock() == blockSpec.getBlock() && Objects.equals(this.objectId, blockSpec.objectId) && MMUtils.areMapsEqual(this.properties, blockSpec.properties) && (!Mods.ArchitectureCraft.isModLoaded() || Objects.equals(this.arch, blockSpec.arch)) && MMUtils.areMapsEqual(this.intrinsicProperties, blockSpec.intrinsicProperties);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.isBlock);
        result = 31 * result + this.objectId.hashCode();
        result = 31 * result + this.metadata;
        result = 31 * result + Objects.hashCode(this.properties);
        if (Mods.ArchitectureCraft.isModLoaded()) {
            result = 31 * result + Objects.hashCode(this.arch);
        }
        result = 31 * result + Objects.hashCode(this.intrinsicProperties);
        result = 31 * result + this.getBlock().hashCode();
        return result;
    }

    public String toString() {
        return "BlockSpec [isBlock=" + this.isBlock + ", objectId=" + this.objectId + ", metadata=" + this.metadata + ", properties=" + this.properties + (Mods.ArchitectureCraft.isModLoaded() ? ", arch=" + this.arch : "") + ", block=" + this.block + ", item=" + this.item + ", itemId=" + this.itemId + ", stack=" + this.stack + "]";
    }

    public static BlockSpec fromPickBlock(World world, EntityPlayer player, MovingObjectPosition hit) {
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return new BlockSpec();
        }
        return BlockSpec.fromBlock(null, world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
    }

    public static BlockSpec fromBlock(BlockSpec pooled, World world, int x, int y, int z) {
        return BlockSpec.fromBlock(pooled, world, x, y, z, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
    }

    public static BlockSpec fromBlock(BlockSpec pooled, World world, int x, int y, int z, Block block, int blockMeta) {
        int itemMeta;
        BlockSpec spec = pooled != null ? pooled.reset() : new BlockSpec();
        spec.isBlock = true;
        spec.objectId = GameRegistry.findUniqueIdentifierFor((Block)block);
        spec.block = block;
        Item item = MMUtils.getItemFromBlock(block, blockMeta);
        if (!InteropConstants.isFree(block, blockMeta)) {
            if (item == null) {
                return BlockSpec.air();
            }
            if (block != Blocks.field_150444_as && block != Blocks.field_150472_an) {
                block = MMUtils.getBlockFromItem(item, item.func_77647_b(blockMeta));
            }
        }
        spec.metadata = itemMeta = block.func_149643_k(world, x, y, z);
        spec.item = Optional.ofNullable(item);
        Optional<Object> optional = spec.itemId = item == null ? Optional.empty() : Optional.of(ItemId.create(item, itemMeta, null));
        if (Mods.ArchitectureCraft.isModLoaded()) {
            spec.arch = ArchitectureCraftAnalysisResult.analyze(world.func_147438_o(x, y, z));
        }
        Object2ObjectOpenHashMap properties = new Object2ObjectOpenHashMap();
        BlockPropertyRegistry.getProperties(world, x, y, z, properties);
        if (!properties.isEmpty()) {
            EnumMap<CopyableProperty, String> values = new EnumMap<CopyableProperty, String>(CopyableProperty.class);
            for (CopyableProperty name : CopyableProperty.VALUES) {
                BlockProperty property = (BlockProperty)properties.get(name.toString());
                if (property == null) continue;
                values.put(name, property.getValueAsString(world, x, y, z));
            }
            if (!values.isEmpty()) {
                spec.properties = values;
            }
        }
        ArrayList<IntrinsicProperty> intrinsicProperties = new ArrayList<IntrinsicProperty>();
        BlockPropertyRegistry.getIntrinsicProperties((IBlockAccess)world, x, y, z, intrinsicProperties);
        if (!intrinsicProperties.isEmpty()) {
            spec.intrinsicProperties = new Object2ObjectOpenHashMap();
            for (IntrinsicProperty prop : intrinsicProperties) {
                spec.intrinsicProperties.put(prop.getName(), prop.getValue((IBlockAccess)world, x, y, z));
            }
        }
        return spec;
    }

    public static BlockSpec air() {
        BlockSpec spec = new BlockSpec();
        spec.block = Blocks.field_150350_a;
        spec.item = Optional.empty();
        spec.itemId = Optional.empty();
        spec.stack = Optional.empty();
        return spec;
    }
}

