/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.tcwands.api.wrappers;

import com.gtnewhorizons.tcwands.api.WandType;
import com.gtnewhorizons.tcwands.api.wandinfo.WandDetails;
import com.gtnewhorizons.tcwands.api.wandinfo.WandProps;
import com.gtnewhorizons.tcwands.api.wrappers.CapWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.config.ConfigItems;

public abstract class AbstractWandWrapper {
    private WandDetails wandDetails;
    private WandProps wandProps;
    private String customResearchName;
    private ItemStack craftingRod;

    public AbstractWandWrapper(WandDetails wandDetails, WandProps wandProps) {
        this.wandDetails = wandDetails;
        this.wandProps = wandProps;
        WandRod wandRod = (WandRod)WandRod.rods.get(this.getRodName());
        if (wandRod == null) {
            throw new NullPointerException("Can't find provided wand rod with id: " + this.getRodName() + ". Be careful to register your custom rod before creating recipes.");
        }
        this.craftingRod = wandRod.getItem();
    }

    public ItemStack getItem(CapWrapper cap) {
        ItemStack wand = new ItemStack(ConfigItems.itemWandCasting);
        NBTTagCompound wandNbt = this.writeNBT(cap);
        wand.func_77982_d(wandNbt);
        wand.func_77964_b(this.getRecipeCost(cap));
        return wand;
    }

    protected NBTTagCompound writeNBT(CapWrapper cap) {
        NBTTagCompound wandNbt = new NBTTagCompound();
        wandNbt.func_74778_a("rod", this.getRodName());
        wandNbt.func_74778_a("cap", cap.getName());
        return wandNbt;
    }

    public int getRecipeCost(CapWrapper cap) {
        return this.wandProps.getBaseCost() + this.wandProps.getCapCost() * cap.getCostMultiplier();
    }

    public abstract Object[] genRecipe(CapWrapper var1);

    public WandProps getProps() {
        return this.wandProps;
    }

    public WandDetails getDetails() {
        return this.wandDetails;
    }

    protected abstract String getDefaultResearchName();

    @NotNull
    public abstract WandType getType();

    public String getResearchName() {
        return this.customResearchName != null ? this.customResearchName : this.getDefaultResearchName();
    }

    public void setCustomResearchName(String customResearchName) {
        this.customResearchName = customResearchName;
    }

    public void setCustomCraftingRod(ItemStack rod) {
        this.craftingRod = rod;
    }

    public ItemStack getCraftingRod() {
        return this.craftingRod;
    }

    public String getRodName() {
        return this.wandDetails.getName();
    }
}

