/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.mixins.early.floorceilbutton;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BlockButton.class})
public class MixinBlockButton
extends Block {
    protected MixinBlockButton(Material materialIn) {
        super(materialIn);
    }

    @Shadow
    public int func_149709_b(IBlockAccess worldIn, int x, int y, int z, int side) {
        return 0;
    }

    @Inject(method={"canPlaceBlockOnSide"}, at={@At(value="HEAD")}, cancellable=true)
    public void canPlaceBlockUpOrDown(World world, int x, int y, int z, int side, CallbackInfoReturnable<Boolean> cir) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (dir == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || dir == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"canPlaceBlockAt"}, at={@At(value="HEAD")}, cancellable=true)
    public void canPlaceBlockAtTopOrBottom(World world, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onBlockPlaced"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockButton;func_150045_e(Lnet/minecraft/world/World;III)I")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onBlockPlacedUpDown(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int var, CallbackInfoReturnable<Integer> cir, int j1, int k1, ForgeDirection dir) {
        if (dir == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            cir.setReturnValue((Object)(5 + k1));
        }
        if (dir == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            cir.setReturnValue((Object)k1);
        }
    }

    @Inject(method={"func_150045_e"}, at={@At(value="HEAD")}, cancellable=true)
    private void findSolidSide_up_down(World worldIn, int x, int y, int z, CallbackInfoReturnable<Integer> cir) {
        if (worldIn.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            cir.setReturnValue((Object)5);
        }
        if (worldIn.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            cir.setReturnValue((Object)0);
        }
    }

    @ModifyVariable(method={"onNeighborBlockChange"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isSideSolid(IIILnet/minecraftforge/common/util/ForgeDirection;)Z", remap=false, shift=At.Shift.BEFORE, ordinal=0))
    public boolean modifyFlag(boolean flag, @Local(argsOnly=true) World world, @Local(ordinal=0, argsOnly=true) int x, @Local(ordinal=1, argsOnly=true) int y, @Local(ordinal=2, argsOnly=true) int z, @Local(ordinal=3) int meta) {
        return flag || meta == 5 && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || meta == 0 && !world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN);
    }

    @Inject(method={"func_150043_b"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void setBlockBoundsFromMeta(int meta, CallbackInfo ci, int j, boolean flag, float f, float f1, float f2, float f3) {
        if (j == 5) {
            this.func_149676_a(0.5f - f2, 0.0f, f, 0.5f + f2, f3, f1);
        } else if (j == 0) {
            this.func_149676_a(0.5f - f2, 1.0f - f3, f, 0.5f + f2, 1.0f, f1);
        }
    }

    @Inject(method={"func_150042_a"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;notifyBlocksOfNeighborChange(IIILnet/minecraft/block/Block;)V", ordinal=5)}, cancellable=true)
    private void updateNeighbor(World world, int x, int y, int z, int buttonMeta, CallbackInfo ci) {
        if (buttonMeta == 0) {
            world.func_147459_d(x, y + 1, z, (Block)this);
            ci.cancel();
        }
    }

    @Inject(method={"isProvidingStrongPower"}, at={@At(value="HEAD")}, cancellable=true)
    public void isProvidingStrongPower(IBlockAccess world, int x, int y, int z, int buttonMeta, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.func_149709_b(world, x, y, z, buttonMeta));
    }
}

