/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.common.gui.dto;

import elan.tweaks.common.gui.dto.Scale;
import elan.tweaks.common.gui.dto.Vector2D;
import elan.tweaks.common.gui.dto.VectorXY;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006H\u0096\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0001H\u0096\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lelan/tweaks/common/gui/dto/Vector3D;", "Lelan/tweaks/common/gui/dto/VectorXY;", "x", "", "y", "z", "", "<init>", "(IID)V", "getX", "()I", "getY", "getZ", "()D", "times", "scalar", "minus", "plus", "Lelan/tweaks/common/gui/dto/Vector2D;", "scale", "Lelan/tweaks/common/gui/dto/Scale;", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "ThaumcraftResearchTweaks"})
public final class Vector3D
implements VectorXY {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final double z;
    @NotNull
    private static final Vector3D ZERO = new Vector3D(0, 0, 0.0);

    public Vector3D(int x, int y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @Override
    @NotNull
    public Vector3D times(double scalar) {
        return new Vector3D(MathKt.roundToInt((double)((double)this.getX() * scalar)), MathKt.roundToInt((double)((double)this.getY() * scalar)), this.z * scalar);
    }

    @Override
    @NotNull
    public Vector3D minus(int scalar) {
        return new Vector3D(this.getX() - scalar, this.getY() - scalar, this.z - (double)scalar);
    }

    @Override
    @NotNull
    public Vector3D plus(int scalar) {
        return new Vector3D(this.getX() + scalar, this.getY() + scalar, this.z + (double)scalar);
    }

    @Override
    @NotNull
    public Vector2D plus(@NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return new Vector2D(this.getX() + scale.getWidth(), this.getY() + scale.getHeight());
    }

    @NotNull
    public final Vector3D plus(@NotNull Vector3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector3D(this.getX() + other.getX(), this.getY() + other.getY(), this.z + other.z);
    }

    @NotNull
    public final Vector3D minus(@NotNull Vector3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector3D(this.getX() - other.getX(), this.getY() - other.getY(), this.z - other.z);
    }

    @Override
    @NotNull
    public Vector3D plus(@NotNull VectorXY other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Vector3D.copy$default(this, this.getX() + other.getX(), this.getY() + other.getY(), 0.0, 4, null);
    }

    @Override
    @NotNull
    public Vector3D minus(@NotNull VectorXY other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Vector3D.copy$default(this, this.getX() - other.getX(), this.getY() - other.getY(), 0.0, 4, null);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Vector3D copy(int x, int y, double z) {
        return new Vector3D(x, y, z);
    }

    public static /* synthetic */ Vector3D copy$default(Vector3D vector3D, int n, int n2, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = vector3D.x;
        }
        if ((n3 & 2) != 0) {
            n2 = vector3D.y;
        }
        if ((n3 & 4) != 0) {
            d = vector3D.z;
        }
        return vector3D.copy(n, n2, d);
    }

    @NotNull
    public String toString() {
        return "Vector3D(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3D)) {
            return false;
        }
        Vector3D vector3D = (Vector3D)other;
        if (this.x != vector3D.x) {
            return false;
        }
        if (this.y != vector3D.y) {
            return false;
        }
        return Double.compare(this.z, vector3D.z) == 0;
    }

    @Override
    public int compareTo(@NotNull VectorXY other) {
        return VectorXY.DefaultImpls.compareTo(this, other);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lelan/tweaks/common/gui/dto/Vector3D$Companion;", "", "<init>", "()V", "ZERO", "Lelan/tweaks/common/gui/dto/Vector3D;", "getZERO", "()Lelan/tweaks/common/gui/dto/Vector3D;", "ThaumcraftResearchTweaks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3D getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

