/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.client.toolbox.ToolboxTabMain;
import betterquesting.network.handlers.NetChapterEdit;
import betterquesting.network.handlers.NetQuestEdit;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ToolboxToolNew
implements IToolboxTool {
    private CanvasQuestLine gui = null;
    private PanelButtonQuest nQuest;

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
        this.nQuest = new PanelButtonQuest(new GuiRectangle(0, 0, 24, 24), -1, "", null);
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
        if (this.nQuest == null) {
            return;
        }
        int snap = ToolboxTabMain.INSTANCE.getSnapValue();
        int modX = (mx % snap + snap) % snap;
        int modY = (my % snap + snap) % snap;
        this.nQuest.rect.x = mx -= modX;
        this.nQuest.rect.y = my -= modY;
        this.nQuest.drawPanel(mx, my, partialTick);
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
        ToolboxTabMain.INSTANCE.drawGrid(this.gui);
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return Collections.emptyList();
    }

    @Override
    public void disableTool() {
        if (this.nQuest != null) {
            this.nQuest = null;
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        IQuestLine qLine = this.gui.getQuestLine();
        UUID qID = QuestDatabase.INSTANCE.generateKey();
        UUID lID = QuestLineDatabase.INSTANCE.lookupKey(qLine);
        IQuestLineEntry qe = (IQuestLineEntry)qLine.get(qID);
        if (qe == null) {
            qe = new QuestLineEntry(this.nQuest.rect.x, this.nQuest.rect.y, 24, 24);
            qLine.put(qID, qe);
        } else {
            qe.setPosition(this.nQuest.rect.x, this.nQuest.rect.y);
            qe.setSize(24, 24);
        }
        NBTTagCompound quPayload = new NBTTagCompound();
        NBTTagList qdList = new NBTTagList();
        NBTTagCompound qTag = NBTConverter.UuidValueType.QUEST.writeId(qID);
        qdList.func_74742_a((NBTBase)qTag);
        quPayload.func_74782_a("data", (NBTBase)qdList);
        quPayload.func_74768_a("action", 3);
        NetQuestEdit.sendEdit(quPayload);
        NBTTagCompound chPayload = new NBTTagCompound();
        NBTTagList cdList = new NBTTagList();
        NBTTagCompound cTag = new NBTTagCompound();
        NBTConverter.UuidValueType.QUEST_LINE.writeId(lID, cTag);
        cTag.func_74782_a("config", qLine.writeToNBT((NBTBase)new NBTTagCompound(), null));
        cdList.func_74742_a((NBTBase)cTag);
        chPayload.func_74782_a("data", (NBTBase)cdList);
        chPayload.func_74768_a("action", 0);
        NetChapterEdit.sendEdit(chPayload);
        return true;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int keyCode) {
        return false;
    }

    @Override
    public boolean clampScrolling() {
        return false;
    }

    @Override
    public void onSelection(List<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean useSelection() {
        return false;
    }
}

