/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.handlers;

import com.cleanroommc.bogosorter.mixins.early.minecraft.GuiContainerAccessor;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.inventory.SlotMerchantResult;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.ClientEventHandler;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;
import yalter.mousetweaks.api.MouseTweaksIgnore;
import yalter.mousetweaks.impl.IGuiScreenHandler;
import yalter.mousetweaks.impl.MouseButton;

public class GuiContainerHandler
implements IGuiScreenHandler {
    protected Minecraft mc = Minecraft.func_71410_x();
    protected GuiContainer guiContainer;
    protected GuiContainerAccessor guiContainerAccessor;

    public GuiContainerHandler(GuiContainer guiContainer) {
        this.guiContainer = guiContainer;
        this.guiContainerAccessor = (GuiContainerAccessor)guiContainer;
    }

    private int getDisplayWidth() {
        return this.mc.field_71443_c;
    }

    private int getDisplayHeight() {
        return this.mc.field_71440_d;
    }

    public int getRequiredMouseX() {
        return Mouse.getX() * this.guiContainer.field_146294_l / this.getDisplayWidth();
    }

    public int getRequiredMouseY() {
        return this.guiContainer.field_146295_m - Mouse.getY() * this.guiContainer.field_146295_m / this.getDisplayHeight() - 1;
    }

    @Override
    public boolean isMouseTweaksDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksIgnore.class) || this.guiContainerAccessor == null || ClientEventHandler.isMouseTweakDisabled(this.guiContainer.getClass());
    }

    @Override
    public boolean isWheelTweakDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksDisableWheelTweak.class) || ClientEventHandler.isWheelTweakDisabled(this.guiContainer.getClass());
    }

    @Override
    public List<Slot> getSlots() {
        return this.guiContainer.field_147002_h.field_75151_b;
    }

    @Override
    public Slot getSlotUnderMouse() {
        return this.guiContainerAccessor.callGetSlotAtPosition(this.getRequiredMouseX(), this.getRequiredMouseY());
    }

    @Override
    public boolean disableRMBDraggingFunctionality() {
        this.guiContainerAccessor.setIgnoreMouseUp(true);
        if (this.guiContainerAccessor.getDragSplitting() && this.guiContainerAccessor.getDragSplittingButton() == 1) {
            this.guiContainerAccessor.setDragSplitting(false);
            return true;
        }
        return false;
    }

    @Override
    public void clickSlot(Slot slot, MouseButton mouseButton, boolean shiftPressed) {
        this.guiContainerAccessor.callHandleMouseClick(slot, slot.field_75222_d, mouseButton.getValue(), shiftPressed ? 1 : 0);
    }

    @Override
    public boolean isCraftingOutput(Slot slot) {
        return slot instanceof SlotCrafting || slot instanceof SlotFurnace || slot instanceof SlotMerchantResult || this.guiContainer.field_147002_h instanceof ContainerRepair && slot.field_75222_d == 2;
    }

    @Override
    public boolean isIgnored(Slot slot) {
        return false;
    }

    @Override
    public int isSlotPrioritized(Slot slot, ItemStack stack) {
        if (ForgeEventFactory.getFuelBurnTime((ItemStack)stack) != 0) {
            if (slot instanceof SlotFurnace) {
                return 1;
            }
            return 0;
        }
        return -1;
    }
}

