/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.cc.TurtlePeripheralBase;
import pl.asie.computronics.cc.TurtleUpgradeBase;
import pl.asie.computronics.util.Camera;

public class CameraTurtleUpgrade
extends TurtleUpgradeBase {
    public CameraTurtleUpgrade(int id) {
        super(id);
    }

    public String getUnlocalisedAdjective() {
        return "Camera";
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)Computronics.camera, 1, 0);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new CameraTurtlePeripheral(turtle);
    }

    public IIcon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return Computronics.camera.getAbsoluteSideIcon(2, 0);
    }

    private static class CameraTurtlePeripheral
    extends TurtlePeripheralBase {
        private final Camera camera = new Camera();

        public CameraTurtlePeripheral(ITurtleAccess access) {
            super(access);
        }

        public String getType() {
            return "camera";
        }

        @Optional.Method(modid="ComputerCraft")
        public String[] getMethodNames() {
            return new String[]{"distance", "distanceUp", "distanceDown"};
        }

        @Optional.Method(modid="ComputerCraft")
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            float x = 0.0f;
            float y = 0.0f;
            if (arguments.length == 2 && arguments[0] instanceof Double && arguments[1] instanceof Double) {
                x = ((Double)arguments[0]).floatValue();
                y = ((Double)arguments[1]).floatValue();
            }
            ChunkCoordinates pos = this.access.getPosition();
            ForgeDirection dir = null;
            switch (method) {
                case 0: {
                    dir = ForgeDirection.getOrientation((int)this.access.getDirection());
                    break;
                }
                case 1: {
                    dir = ForgeDirection.UP;
                    break;
                }
                case 2: {
                    dir = ForgeDirection.DOWN;
                }
            }
            if (dir != null) {
                this.camera.ray(this.access.getWorld(), pos.field_71574_a, pos.field_71572_b, pos.field_71573_c, dir, x, y);
                return new Object[]{this.camera.getDistance()};
            }
            return null;
        }
    }
}

