/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.village;

import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageComponent;
import de.katzenpapst.amunra.world.mapgen.village.GridVillageStart;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class PyramidHouseComponent
extends GridVillageComponent {
    protected int houseHeight = 5;

    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] blocks, byte[] metas) {
        int xCenter;
        StructureBoundingBox chunkBB = CoordHelper.getChunkBB(chunkX, chunkZ);
        int fallbackGround = this.parent.getWorldGroundLevel();
        if (this.groundLevel == -1) {
            this.groundLevel = PyramidHouseComponent.getAverageGroundLevel(blocks, metas, this.getStructureBoundingBox(), chunkBB, fallbackGround);
            if (this.groundLevel == -1) {
                this.groundLevel = fallbackGround;
            }
        }
        StructureBoundingBox myBB = this.getStructureBoundingBox();
        BlockMetaPair wall = ((GridVillageStart)this.parent).getWallMaterial();
        BlockMetaPair floor = ((GridVillageStart)this.parent).getFloorMaterial();
        BlockMetaPair padding = ((GridVillageStart)this.parent).getFillMaterial();
        boolean startX = false;
        int stopX = myBB.func_78883_b() - 1;
        boolean startZ = false;
        int stopZ = myBB.func_78880_d() - 1;
        int radius = xCenter = (int)Math.ceil((stopX - 0) / 2 + 0);
        for (int x = 0; x <= stopX; ++x) {
            for (int z = 0; z <= stopZ; ++z) {
                int y;
                int highestGroundBlock = this.getHighestSolidBlockInBB(blocks, metas, chunkX, chunkZ, x, z);
                if (highestGroundBlock == -1) continue;
                for (y = highestGroundBlock - 1; y < this.groundLevel; ++y) {
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, y, z, padding);
                }
                this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel - 1, z, floor);
                if (0 == x || 0 == z || stopX == x || stopZ == z) {
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel, z, wall);
                }
                for (y = 0; y <= radius; ++y) {
                    if ((x < 0 + y || x > stopX - y || z != 0 + y && z != stopZ - y) && (x != 0 + y && x != stopX - y || z < 0 + y || z > stopZ - y)) continue;
                    this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, this.groundLevel + y + 1, z, wall);
                }
            }
        }
        return true;
    }
}

