/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.shape;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.common.block.BlockArchitecture;
import gcewing.architecture.common.shape.Banister;
import gcewing.architecture.common.shape.Cladding;
import gcewing.architecture.common.shape.Model;
import gcewing.architecture.common.shape.Profile;
import gcewing.architecture.common.shape.Roof;
import gcewing.architecture.common.shape.Shape;
import gcewing.architecture.common.tile.TileArchitecture;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.Directions;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import gcewing.architecture.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public abstract class ShapeKind {
    public Object[] profiles;
    public static final Roof Roof = new Roof();
    public static final Cladding Cladding = new Cladding();

    public Object profileForLocalFace(Shape shape, EnumFacing face) {
        if (this.profiles != null) {
            return this.profiles[face.ordinal()];
        }
        return null;
    }

    public double placementOffsetX() {
        return 0.0;
    }

    public abstract void renderShape(TileShape var1, ITexture[] var2, IRenderTarget var3, Trans3 var4, boolean var5, boolean var6);

    public ItemStack newStack(Shape shape, IBlockState materialState, int stackSize) {
        return this.newStack(shape, materialState.getBlock(), BlockCompatUtils.getMetaFromBlockState(materialState), stackSize);
    }

    public ItemStack newStack(Shape shape, IBlockState materialState, int stackSize, boolean shaderEmissive) {
        return this.newStack(shape, materialState.getBlock(), BlockCompatUtils.getMetaFromBlockState(materialState), stackSize, shaderEmissive);
    }

    public ItemStack newStack(Shape shape, Block materialBlock, int materialMeta, int stackSize) {
        TileShape te = new TileShape(shape, materialBlock, materialMeta);
        int light = materialBlock.func_149750_m();
        ItemStack result = TileArchitecture.blockStackWithTileEntity((Block)ArchitectureCraft.content.blockShape, stackSize, light, te);
        return result;
    }

    public ItemStack newStack(Shape shape, Block materialBlock, int materialMeta, int stackSize, boolean shaderEmissive) {
        TileShape te = new TileShape(shape, materialBlock, materialMeta);
        int light = materialBlock.func_149750_m();
        if (shape.id == Shape.CladdingSheet.id) {
            return ArchitectureCraft.content.itemCladding.newStack(materialBlock, materialMeta, stackSize);
        }
        if (shaderEmissive) {
            light = 15;
            ItemStack result = TileArchitecture.blockStackWithTileEntity((Block)ArchitectureCraft.content.blockShapeSE, stackSize, light, te);
            return result;
        }
        ItemStack result = TileArchitecture.blockStackWithTileEntity((Block)ArchitectureCraft.content.blockShape, stackSize, light, te);
        return result;
    }

    public boolean orientOnPlacement(EntityPlayer player, TileShape te, BlockPos npos, IBlockState nstate, TileEntity nte, EnumFacing otherFace, Vector3 hit) {
        if (nte instanceof TileShape) {
            return this.orientOnPlacement(player, te, (TileShape)nte, otherFace, hit);
        }
        return this.orientOnPlacement(player, te, null, otherFace, hit);
    }

    public boolean orientOnPlacement(EntityPlayer player, TileShape te, TileShape nte, EnumFacing otherFace, Vector3 hit) {
        Object otherProfile;
        if (nte != null && !player.func_70093_af() && (otherProfile = Profile.getProfileGlobal(nte.shape, nte.side, nte.turn, otherFace)) != null) {
            EnumFacing thisFace = Utils.oppositeFacing(otherFace);
            for (int i = 0; i < 4; ++i) {
                int turn = nte.turn + i & 3;
                Object thisProfile = Profile.getProfileGlobal(te.shape, nte.side, turn, thisFace);
                if (!Profile.matches(thisProfile, otherProfile)) continue;
                te.setSide(nte.side);
                te.setTurn(turn);
                te.setOffsetX(nte.getOffsetX());
                return true;
            }
        }
        return false;
    }

    public boolean canPlaceUpsideDown() {
        return true;
    }

    public double sideZoneSize() {
        return 0.25;
    }

    public boolean highlightZones() {
        return false;
    }

    public void onChiselUse(TileShape te, EntityPlayer player, EnumFacing face, Vector3 hit) {
        EnumFacing side = this.zoneHit(face, hit);
        if (side != null) {
            this.chiselUsedOnSide(te, player, side);
        } else {
            this.chiselUsedOnCentre(te, player);
        }
    }

    public void chiselUsedOnSide(TileShape te, EntityPlayer player, EnumFacing side) {
        te.toggleConnectionGlobal(side);
    }

    public void chiselUsedOnCentre(TileShape te, EntityPlayer player) {
        ItemStack stack;
        if (te.secondaryBlockState != null && (stack = this.newSecondaryMaterialStack(te.secondaryBlockState)) != null) {
            if (!Utils.playerIsInCreativeMode(player)) {
                BlockArchitecture block = (BlockArchitecture)te.func_145838_q();
                block.spawnAsEntity(BlockCompatUtils.getTileEntityWorld(te), BlockCompatUtils.getTileEntityPos(te), stack);
            }
            te.setSecondaryMaterial(null);
        }
    }

    public ItemStack newSecondaryMaterialStack(IBlockState state) {
        if (this.acceptsCladding()) {
            return ArchitectureCraft.content.itemCladding.newStack(state, 1);
        }
        return null;
    }

    public void onHammerUse(TileShape te, EntityPlayer player, EnumFacing face, Vector3 hit) {
        if (player.func_70093_af()) {
            te.setSide((te.side + 1) % 6);
        } else {
            double dx = te.getOffsetX();
            if (dx != 0.0) {
                dx = -dx;
                te.setOffsetX(dx);
            }
            if (dx >= 0.0) {
                te.setTurn((te.turn + 1) % 4);
            }
        }
        te.markChanged();
    }

    public EnumFacing zoneHit(EnumFacing face, Vector3 hit) {
        double r = 0.5 - this.sideZoneSize();
        int dir = face.ordinal();
        if (hit.x <= -r && dir != 4) {
            return Directions.F_WEST;
        }
        if (hit.x >= r && dir != 5) {
            return Directions.F_EAST;
        }
        if (hit.y <= -r && dir != 0) {
            return Directions.F_DOWN;
        }
        if (hit.y >= r && dir != 1) {
            return Directions.F_UP;
        }
        if (hit.z <= -r && dir != 2) {
            return Directions.F_NORTH;
        }
        if (hit.z >= r && dir != 3) {
            return Directions.F_SOUTH;
        }
        return null;
    }

    public boolean acceptsCladding() {
        return false;
    }

    public boolean isValidSecondaryMaterial(IBlockState state) {
        return false;
    }

    public boolean secondaryDefaultsToBase() {
        return false;
    }

    public AxisAlignedBB getBounds(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        this.addCollisionBoxesToList(te, world, pos, state, entity, t, list);
        return Utils.unionOfBoxes(list);
    }

    public void addCollisionBoxesToList(TileShape te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
        int mask = te.shape.occlusionMask;
        int param = mask & 0xFF;
        switch (mask & 0xFF00) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    if ((mask & 1 << i) == 0) continue;
                    Vector3 p = new Vector3((i & 1) != 0 ? 0.5 : -0.5, (i & 4) != 0 ? 0.5 : -0.5, (i & 2) != 0 ? 0.5 : -0.5);
                    this.addBox(Vector3.zero, p, t, list);
                }
                break;
            }
            case 256: {
                double r = (double)param / 16.0;
                this.addBox(new Vector3(-r, -0.5, -r), new Vector3(r, 0.5, r), t, list);
                break;
            }
            case 512: {
                double r = (double)param / 32.0;
                this.addBox(new Vector3(-0.5, -0.5, -r), new Vector3(0.5, 0.5, r), t, list);
                break;
            }
            case 768: {
                double r = (double)((param & 0xF) + 1) / 16.0;
                double h = (double)((param >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - r), new Vector3(-0.5 + r, -0.5 + h, 0.5), t, list);
                break;
            }
            case 1024: 
            case 1280: {
                double r = (double)((param & 0xF) + 1) / 16.0;
                double h = (double)((param >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - r), new Vector3(0.5, -0.5 + h, 0.5), t, list);
                if ((mask & 0x100) == 0) break;
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(-0.5 + r, -0.5 + h, 0.5), t, list);
                break;
            }
            default: {
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(0.5, 0.5, 0.5), t, list);
            }
        }
    }

    protected void addBox(Vector3 p0, Vector3 p1, Trans3 t, List list) {
        t.addBox(p0, p1, list);
    }

    public static Model Model(String name) {
        return new Model(name, null);
    }

    public static Model Model(String name, Object[] profiles) {
        return new Model(name, profiles);
    }

    public static Model Banister(String name) {
        return new Banister(name);
    }
}

