/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import galaxyspace.ACentauriSystem.ACentauriPlanets;
import galaxyspace.BarnardsSystem.BarnardsPlanets;
import galaxyspace.SolarSystem.SolarSystemPlanets;
import galaxyspace.TCetiSystem.TCetiPlanets;
import galaxyspace.VegaSystem.VegaPlanets;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class GSColorRingClient {
    private static final ResourceLocation SATURN_RING_TEXTURE = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/saturnRings.png");
    private static final ResourceLocation URANUS_RING_TEXTURE = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/uranusRings.png");
    private static final ResourceLocation BARNARDA_RING_TEXTURE = new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/barnardaRings.png");
    private static final ResourceLocation BARNARDA_RING_TEXTURE_2 = new ResourceLocation("galaxyspace", "textures/gui/celestialbodies/barnardaRings2.png");
    private final Minecraft minecraft = FMLClientHandler.instance().getClient();

    @SubscribeEvent
    public void onRingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)SolarSystemPlanets.planetKuiperBelt) || renderEvent.celestialBody.equals((Object)BarnardsPlanets.planetBarnardaAsteroids) || renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids2) || renderEvent.celestialBody.getRingColorR() == 1.1f) {
            this.renderRing(renderEvent, renderEvent.celestialBody, 0.7f, 0.0f, 0.0f);
        }
        if (renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids)) {
            this.renderRing(renderEvent, renderEvent.celestialBody, 0.7f, 0.0f, 0.0f);
        }
        if (renderEvent.celestialBody.equals((Object)GalacticraftCore.planetOverworld) || renderEvent.celestialBody.equals((Object)BarnardsPlanets.planetBarnarda2) || renderEvent.celestialBody.getRingColorG() == 1.1f) {
            this.renderRing(renderEvent, renderEvent.celestialBody, 0.0f, 0.7f, 0.0f);
        }
        if (renderEvent.celestialBody.equals((Object)ACentauriPlanets.centauriB) || renderEvent.celestialBody.equals((Object)ACentauriPlanets.proxima) || renderEvent.celestialBody.getRingColorR() == 0.0f) {
            renderEvent.setCanceled(true);
        }
    }

    private void renderRing(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, CelestialBody aroundBody, float r, float g, float b) {
        float temp;
        int i;
        float max;
        float min;
        Vector3f mapPos = renderEvent.parentOffset;
        float xOffset = mapPos.x;
        float yOffset = mapPos.y;
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection) {
            GL11.glColor4f((float)r, (float)g, (float)b, (float)0.5f);
        } else {
            GL11.glColor4f((float)0.3f, (float)0.1f, (float)0.1f, (float)1.0f);
        }
        renderEvent.setCanceled(true);
        GL11.glBegin((int)2);
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        if (aroundBody instanceof Moon) {
            min = 0.5263158f;
            max = 0.6666667f;
        } else {
            min = 72.0f;
            max = 78.0f;
        }
        float x = max * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        float y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min * renderEvent.celestialBody.getRelativeDistanceFromCenter().scaledDistance;
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)r, (float)g, (float)b, (float)0.1f);
        GL11.glBegin((int)7);
        x = min * renderEvent.celestialBody.getRelativeDistanceFromCenter().scaledDistance;
        y = 0.0f;
        float x2 = max * renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance;
        float y2 = 0.0f;
        for (int j = 0; j < 90; ++j) {
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            float temp2 = x;
            x = cos * x - sin * y;
            y = sin * temp2 + cos * y;
            temp2 = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp2 + cos * y2;
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
        }
        GL11.glEnd();
    }

    @SubscribeEvent
    public void onBodyRender(CelestialBodyRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.equals((Object)SolarSystemPlanets.planetKuiperBelt) || renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids) || renderEvent.celestialBody.equals((Object)BarnardsPlanets.planetBarnardaAsteroids) || renderEvent.celestialBody.equals((Object)VegaPlanets.planetVegaasteroids2) || renderEvent.celestialBody.equals((Object)TCetiPlanets.tcetiAsteroids)) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void onRenderPlanetPost(CelestialBodyRenderEvent.Post event) {
        GuiScreen guiScreen = this.minecraft.field_71462_r;
        if (guiScreen instanceof GuiCelestialSelection) {
            GuiCelestialSelection gui = (GuiCelestialSelection)guiScreen;
            float size = (float)GuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)event.celestialBody) / 6.0f;
            if (event.celestialBody == SolarSystemPlanets.planetSaturn) {
                this.minecraft.field_71446_o.func_110577_a(SATURN_RING_TEXTURE);
                gui.drawTexturedModalRect(-7.5f * size, -1.75f * size, 15.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 7.0f, false, false, 30.0f, 7.0f);
            } else if (event.celestialBody == SolarSystemPlanets.planetUranus) {
                this.minecraft.field_71446_o.func_110577_a(URANUS_RING_TEXTURE);
                gui.drawTexturedModalRect(-1.75f * size, -7.0f * size, 3.5f * size, 14.0f * size, 0.0f, 0.0f, 28.0f, 7.0f, false, false, 28.0f, 7.0f);
            } else if (event.celestialBody == BarnardsPlanets.planetBarnarda5) {
                GL11.glEnable((int)3042);
                this.minecraft.field_71446_o.func_110577_a(BARNARDA_RING_TEXTURE);
                gui.drawTexturedModalRect(-11.0f * size, -1.75f * size, 22.0f * size, 3.5f * size, 0.0f, 0.0f, 32.0f, 7.0f, false, false, 32.0f, 7.0f);
            } else if (event.celestialBody == BarnardsPlanets.planetBarnarda6) {
                GL11.glEnable((int)3042);
                this.minecraft.field_71446_o.func_110577_a(BARNARDA_RING_TEXTURE_2);
                gui.drawTexturedModalRect(-11.4f * size, -1.75f * size, 23.4f * size, 3.5f * size, 0.0f, 0.0f, 32.0f, 7.0f, false, false, 32.0f, 7.0f);
            }
        }
    }
}

