/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.util.I18N;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignCategory;
import java.util.ArrayList;
import java.util.List;

public enum EnumDesignCategory implements IDesignCategory
{
    Design("designsEmblems"),
    Stripes("squaresStripes"),
    Edges("edges"),
    Barred("bars"),
    Letters("letters"),
    Diagonal("diagonals");

    private final String name;
    private final List<IDesign> designs;

    private EnumDesignCategory(String name) {
        this.name = name;
        this.designs = new ArrayList<IDesign>();
        CarpentryManager.carpentryInterface.registerDesignCategory(this);
    }

    @Override
    public String getName() {
        return I18N.localise("botany.design.category." + this.name);
    }

    @Override
    public List<IDesign> getDesigns() {
        return this.designs;
    }

    @Override
    public void addDesign(IDesign design) {
        this.designs.add(design);
    }

    @Override
    public String getId() {
        return this.toString().toLowerCase();
    }
}

