/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.common.command;

import java.util.List;
import java.util.UUID;
import net.techbrew.journeymapserver.common.chat.ChatHandler;
import net.techbrew.journeymapserver.common.config.ConfigHandler;
import net.techbrew.journeymapserver.common.config.Configuration;
import net.techbrew.journeymapserver.common.network.PacketManager;
import net.techbrew.journeymapserver.common.util.TabCompletionHelper;

public class CommandJourneyMapServer {
    public void processCommand(String sender, String world, String[] args) {
        switch (args[0].toLowerCase()) {
            case "worldid": {
                if (ConfigHandler.getConfigByWorldName(world).isUsingWorldID()) {
                    this.processWorldID(sender, world, args);
                    break;
                }
                ChatHandler.sendMessage(sender, "\u00a74WorldID settings are disabled.");
                break;
            }
            case "help": {
                this.processJMServerHelp(sender);
                break;
            }
        }
    }

    private void processJMServerHelp(String sender) {
        ChatHandler.sendMessage(sender, "\u00a7b--- JourneyMapServer Commands ---");
        ChatHandler.sendMessage(sender, "\u00a7b--------------------------------");
        ChatHandler.sendMessage(sender, "\u00a72worldid : Displays current World ID.\u00a74(Has Sub-Commands)");
        ChatHandler.sendMessage(sender, "\u00a74/jmserver <command> help for more info about sub-commands");
    }

    private void processWorldID(String sender, String world, String[] args) {
        if (args.length > 1) {
            switch (args[1].toLowerCase()) {
                case "help": {
                    this.processWorldIDHelp(sender);
                    break;
                }
                case "set": {
                    this.processSetWorldID(sender, world, args[2]);
                    break;
                }
                case "setrandom": {
                    this.processSetWorldID(sender, world, UUID.randomUUID().toString());
                    break;
                }
                case "resync": {
                    ChatHandler.sendMessage(sender, "Re-Syncing all clients!");
                    PacketManager.instance.sendAllPlayersWorldID(world);
                    break;
                }
                default: {
                    ChatHandler.sendMessage(sender, "/jmserver worldid help|set|setrandom|resync|(blank)");
                    break;
                }
            }
        } else {
            ChatHandler.sendMessage(sender, String.format("World ID: %s", ConfigHandler.getConfigByWorldName(world).getWorldID()));
        }
    }

    private void processSetWorldID(String sender, String world, String worldID) {
        Configuration config = ConfigHandler.getConfigByWorldName(world);
        config.setWorldID(worldID);
        ConfigHandler.saveWorld(config, world);
        PacketManager.instance.sendAllPlayersWorldID(worldID);
        ChatHandler.sendMessage(sender, String.format("WorldID set to %s", worldID));
    }

    private void processWorldIDHelp(String sender) {
        ChatHandler.sendMessage(sender, "\u00a7b------- WorldID Commands -------");
        ChatHandler.sendMessage(sender, "\u00a7b------------------------------");
        ChatHandler.sendMessage(sender, "\u00a72set <name> : Sets the custom WorldID");
        ChatHandler.sendMessage(sender, "\u00a72setrandom : Sets the World ID to a random hash UUID");
        ChatHandler.sendMessage(sender, "\u00a72resync : Re-syncs all clients with the current World ID");
    }

    public List<String> retrieveTabCompleteValues(String[] args) {
        if (args.length == 1) {
            return TabCompletionHelper.getListOfStringsMatchingLastWord(args, "help", "worldid");
        }
        if (args.length == 2 && "worldid".equalsIgnoreCase(args[0])) {
            return TabCompletionHelper.getListOfStringsMatchingLastWord(args, "help", "set", "setrandom", "resync");
        }
        return null;
    }
}

