/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class CartMaintenanceBase
extends CartContainerBase {
    protected static final double DRAG_FACTOR = 0.9;
    protected static final float MAX_SPEED = 0.1f;
    private static final int BLINK_DURATION = 3;
    private static final int DATA_ID_BLINK = 25;

    public CartMaintenanceBase(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
    }

    public int func_70302_i_() {
        return 0;
    }

    protected void blink() {
        this.field_70180_af.func_75692_b(25, (Object)3);
    }

    protected void setBlink(byte blink) {
        this.field_70180_af.func_75692_b(25, (Object)blink);
    }

    protected byte getBlink() {
        return this.field_70180_af.func_75683_a(25);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        if (this.isBlinking()) {
            this.setBlink((byte)(this.getBlink() - 1));
        }
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean canBeRidden() {
        return false;
    }

    @Override
    public double getDrag() {
        return 0.9;
    }

    public float getMaxCartSpeedOnRail() {
        return 0.1f;
    }

    public boolean isBlinking() {
        return this.field_70180_af.func_75683_a(25) > 0;
    }

    protected boolean placeNewTrack(int x, int y, int z, int slotStock, int meta) {
        ItemStack trackStock = this.func_70301_a(slotStock);
        if (trackStock != null && RailTools.placeRailAt(trackStock, this.field_70170_p, x, y, z)) {
            this.field_70170_p.func_72921_c(x, y, z, meta, 2);
            Block block = this.field_70170_p.func_147439_a(x, y, z);
            block.func_149695_a(this.field_70170_p, x, y, z, block);
            this.field_70170_p.func_147471_g(x, y, z);
            this.func_70298_a(slotStock, 1);
            this.blink();
            return true;
        }
        return false;
    }

    protected int removeOldTrack(int x, int y, int z, Block block) {
        ArrayList drops = block.getDrops(this.field_70170_p, x, y, z, 0, 0);
        for (ItemStack stack : drops) {
            CartTools.offerOrDropItem((EntityMinecart)this, stack);
        }
        int meta = this.field_70170_p.func_72805_g(x, y, z);
        if (((BlockRailBase)block).func_150050_e()) {
            meta &= 7;
        }
        this.field_70170_p.func_147468_f(x, y, z);
        return meta;
    }
}

