/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.sanctuary.data;

import chylex.hee.system.util.CycleProtection;
import chylex.hee.world.structure.util.Facing;
import chylex.hee.world.util.Direction;
import java.util.ArrayList;
import java.util.Random;

public final class SanctuaryMazeGen {
    private final byte width;
    private final byte depth;
    private final boolean[][] openX;
    private final boolean[][] openZ;

    SanctuaryMazeGen(int width, int depth) {
        this.width = (byte)width;
        this.depth = (byte)depth;
        this.openX = new boolean[width - 1][depth];
        this.openZ = new boolean[depth - 1][width];
    }

    public boolean hasConnections(int x, int z, Facing facing) {
        int dir = facing.get4Directional();
        if ((x += Direction.offsetX[dir]) < 0 || (z += Direction.offsetZ[dir]) < 0 || x >= this.width || z >= this.depth) {
            return false;
        }
        for (int ldir = 0; ldir < 4; ++ldir) {
            if (!this.isOpen(x, z, Facing.from4Directional(ldir))) continue;
            return true;
        }
        return false;
    }

    public boolean isOpen(int x, int z, Facing facing) {
        int dir = facing.get4Directional();
        int x2 = x + Direction.offsetX[dir];
        int z2 = z + Direction.offsetZ[dir];
        if (x2 < 0 || z2 < 0 || x2 >= this.width || z2 >= this.depth) {
            return false;
        }
        return x == x2 ? this.openZ[Math.min(z, z2)][x] : this.openX[Math.min(x, x2)][z];
    }

    boolean setOpen(int x, int z, Facing facing) {
        int dir = facing.get4Directional();
        int x2 = x + Direction.offsetX[dir];
        int z2 = z + Direction.offsetZ[dir];
        if (x2 < 0 || z2 < 0 || x2 >= this.width || z2 >= this.depth) {
            return false;
        }
        if (x == x2) {
            this.openZ[Math.min((int)z, (int)z2)][x] = true;
        } else {
            this.openX[Math.min((int)x, (int)x2)][z] = true;
        }
        return true;
    }

    boolean isDone() {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.depth; ++z) {
                for (int dir = 0; dir < 4 && !this.isOpen(x, z, Facing.from4Directional(dir)); ++dir) {
                    if (dir != 3) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static SanctuaryMazeGen generate(Random rand, int width, int depth) {
        SanctuaryMazeGen maze = new SanctuaryMazeGen(width, depth);
        CycleProtection.setCounter(4000);
        int x = 0;
        int z = rand.nextInt(depth);
        int test = 0;
        ArrayList<int[]> used = new ArrayList<int[]>();
        while (!maze.isDone() && CycleProtection.proceed()) {
            int dir = rand.nextInt(4);
            if (!maze.hasConnections(x, z, Facing.from4Directional(dir)) && maze.setOpen(x, z, Facing.from4Directional(dir))) {
                used.add(new int[]{x, z});
                x += Direction.offsetX[dir];
                z += Direction.offsetZ[dir];
                continue;
            }
            if (++test <= 8 || used.isEmpty()) continue;
            int[] pos = (int[])used.get(rand.nextInt(used.size()));
            x = pos[0];
            z = pos[1];
            test = 0;
        }
        if (CycleProtection.failed()) {
            return maze;
        }
        for (int connect = 6 + rand.nextInt(10); connect > 0; --connect) {
            x = rand.nextInt(width);
            z = rand.nextInt(depth);
            maze.setOpen(x, z, Facing.from4Directional(rand.nextInt(4)));
        }
        return maze;
    }
}

