/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.savedata.types;

import chylex.hee.mechanics.misc.LoreTexts;
import chylex.hee.system.savedata.WorldSavefile;
import gnu.trove.list.array.TByteArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public class LoreSavefile
extends WorldSavefile {
    private final Map<UUID, byte[]> unlockedPages = new HashMap<UUID, byte[]>();

    public LoreSavefile() {
        super("lore.nbt");
    }

    public byte[] getUnlockedPages(EntityPlayer player) {
        byte[] pages = this.unlockedPages.get(player.func_146103_bH().getId());
        return pages != null ? pages : ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    public int unlockNextPage(EntityPlayer player) {
        byte[] alreadyUnlocked = this.getUnlockedPages(player);
        if (alreadyUnlocked.length < LoreTexts.pageAmount) {
            TByteArrayList list = new TByteArrayList(LoreTexts.pageAmount);
            for (byte a = 1; a <= LoreTexts.pageAmount; a = (byte)(a + 1)) {
                list.add(a);
            }
            list.removeAll(alreadyUnlocked);
            if (list.isEmpty()) {
                return -1;
            }
            list.sort();
            byte[] updated = new byte[alreadyUnlocked.length + 1];
            for (int a = 0; a < alreadyUnlocked.length; ++a) {
                updated[a] = alreadyUnlocked[a];
            }
            updated[alreadyUnlocked.length] = list.get(0);
            this.unlockedPages.put(player.func_146103_bH().getId(), updated);
            this.setModified();
            return list.get(0);
        }
        return -1;
    }

    public void unlockPage(EntityPlayer player, int page) {
        byte[] alreadyUnlocked = this.getUnlockedPages(player);
        if (ArrayUtils.contains((byte[])alreadyUnlocked, (byte)((byte)page))) {
            return;
        }
        byte[] updated = new byte[alreadyUnlocked.length + 1];
        for (int a = 0; a < alreadyUnlocked.length; ++a) {
            updated[a] = alreadyUnlocked[a];
        }
        updated[alreadyUnlocked.length] = (byte)page;
        this.unlockedPages.put(player.func_146103_bH().getId(), updated);
        this.setModified();
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        for (Map.Entry<UUID, byte[]> entry : this.unlockedPages.entrySet()) {
            nbt.func_74773_a(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        this.unlockedPages.clear();
        for (String key : nbt.func_150296_c()) {
            this.unlockedPages.put(UUID.fromString(key), nbt.func_74770_j(key));
        }
    }
}

