/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.brewing;

import chylex.hee.init.ItemList;
import chylex.hee.item.ItemAbstractPotion;
import chylex.hee.mechanics.brewing.AbstractPotionData;
import chylex.hee.mechanics.brewing.EmptyPotion;
import chylex.hee.mechanics.brewing.InstantPotion;
import chylex.hee.mechanics.brewing.TimedPotion;
import chylex.hee.system.util.ItemDamagePair;
import chylex.hee.system.util.ItemUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.apache.commons.lang3.ArrayUtils;

public class PotionTypes {
    public static final List<AbstractPotionData> potionData = Arrays.asList(new EmptyPotion(null, 0, 16), new InstantPotion(Potion.field_76432_h, 16, 8197, 3, 4), new InstantPotion(Potion.field_76433_i, 8197, 8204, 3, 4), new TimedPotion(Potion.field_76424_c, 16, 8194, 3, 4, 60, 720), new TimedPotion(Potion.field_76421_d, 8194, 8202, 3, 4, 30, 480, 30), new TimedPotion(Potion.field_76420_g, 16, 8201, 3, 4, 60, 720), new TimedPotion(Potion.field_76437_t, 8195, 8200, 3, 4, 30, 480, 30), new TimedPotion(Potion.field_76439_r, 16, 8198, 1, 1, 30, 600), new TimedPotion(Potion.field_76441_p, 8198, 8206, 1, 1, 30, 600), new TimedPotion(Potion.field_76428_l, 16, 8193, 3, 4, 15, 120, 15), new TimedPotion(Potion.field_76436_u, 16, 8196, 3, 4, 6, 48, 6), new TimedPotion(Potion.field_76426_n, 16, 8195, 1, 1, 60, 600), new TimedPotion(Potion.field_76427_o, 16, 0, 1, 1, 60, 720, 60), new TimedPotion(Potion.field_76440_q, 16, 8197, 1, 1, 6, 48, 6), new TimedPotion(Potion.field_76430_j, 16, 8192, 3, 4, 60, 600), new TimedPotion(Potion.field_76431_k, 8251, 8253, 1, 1, 6, 48, 6));
    private static final Map<Item, Item> customPotions = new HashMap<Item, Item>();
    private static final Map<ItemDamagePair, byte[]> itemToIndex = new HashMap<ItemDamagePair, byte[]>();

    private static void mapItemToIndex(Item item, int ... indexes) {
        PotionTypes.mapItemToIndex(item, (Short)0, indexes);
    }

    private static void mapItemToIndex(Item item, Short damage, int ... indexes) {
        byte[] byteIndexes = new byte[indexes.length];
        for (int a = 0; a < indexes.length; ++a) {
            byteIndexes[a] = (byte)indexes[a];
        }
        itemToIndex.put(new ItemDamagePair(item, damage.shortValue()), byteIndexes);
    }

    public static byte[] getItemIndexes(ItemStack is) {
        for (Map.Entry<ItemDamagePair, byte[]> entry : itemToIndex.entrySet()) {
            ItemDamagePair item = entry.getKey();
            if (!item.check(is)) continue;
            return entry.getValue();
        }
        return ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    public static boolean isSpecialIngredient(Item item) {
        return customPotions.containsKey(item);
    }

    public static boolean isPotionItem(Item item) {
        return item instanceof ItemPotion || item == Items.field_151069_bo || customPotions.containsValue(item);
    }

    public static PotionEffect getEffectIfValid(ItemStack is) {
        List list = Items.field_151068_bn.func_77832_l(is);
        return list == null || list.size() != 1 ? null : (PotionEffect)list.get(0);
    }

    public static AbstractPotionData getPotionData(ItemStack is) {
        for (AbstractPotionData data : potionData) {
            if (data.damageValue != (is.func_77960_j() & 0xFFFFBFFF)) continue;
            return data;
        }
        return null;
    }

    public static int getRequiredPowder(Item ingredient, ItemStack is) {
        if (is.func_77960_j() <= 16) {
            if (is.func_77960_j() == 16 && customPotions.containsKey(ingredient)) {
                return 8;
            }
            if (ingredient == Items.field_151016_H) {
                return 3;
            }
            return 0;
        }
        PotionEffect eff = PotionTypes.getEffectIfValid(is);
        if (eff == null) {
            return 0;
        }
        if (ingredient == Items.field_151137_ax) {
            AbstractPotionData potionData = PotionTypes.getPotionData(is);
            if (potionData instanceof TimedPotion) {
                return ((TimedPotion)potionData).getDurationLevel(eff.func_76459_b()) / 2 + 1;
            }
        } else {
            if (ingredient == Items.field_151114_aO) {
                return 2 * (eff.func_76458_c() + 1);
            }
            if (ingredient == Items.field_151016_H) {
                return 3;
            }
        }
        return 0;
    }

    public static boolean canBeApplied(ItemStack ingredient, ItemStack is, boolean enhanced) {
        byte[] indexes = PotionTypes.getItemIndexes(ingredient);
        if (indexes.length == 0) {
            Item ingredientItem = ingredient.func_77973_b();
            if (is.func_77960_j() <= 16) {
                if (PotionTypes.isSpecialIngredient(ingredientItem)) {
                    return is.func_77960_j() == 16;
                }
                if (ingredientItem == Items.field_151016_H && is.func_77973_b() instanceof ItemAbstractPotion) {
                    return is.func_77960_j() == 0;
                }
                return false;
            }
            if (ingredientItem == Items.field_151016_H) {
                return !ItemPotion.func_77831_g((int)is.func_77960_j());
            }
            if (ingredientItem == Items.field_151114_aO) {
                AbstractPotionData data = PotionTypes.getPotionData(is);
                return data != null && data.canIncreaseLevel(is, enhanced);
            }
            if (ingredientItem == Items.field_151137_ax) {
                AbstractPotionData data = PotionTypes.getPotionData(is);
                return data instanceof TimedPotion && ((TimedPotion)data).canIncreaseDuration(is);
            }
            return false;
        }
        byte[] byArray = indexes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            AbstractPotionData data = potionData.get(b.byteValue());
            if (data.requiredDamageValue != (is.func_77960_j() & 0xFFFFBFFF)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack applyIngredientUnsafe(ItemStack ingredient, ItemStack is) {
        Item ingredientItem = ingredient.func_77973_b();
        if (PotionTypes.isSpecialIngredient(ingredientItem) || ingredientItem == Items.field_151016_H && is.func_77973_b() instanceof ItemAbstractPotion) {
            if (ingredientItem == Items.field_151016_H) {
                return new ItemStack(is.func_77973_b(), 1, 1);
            }
            return new ItemStack(customPotions.get(ingredientItem));
        }
        byte[] indexes = PotionTypes.getItemIndexes(ingredient);
        if (indexes.length == 0) {
            PotionEffect eff = PotionTypes.getEffectIfValid(is);
            if (eff == null) {
                return is;
            }
            if (ingredientItem == Items.field_151016_H) {
                PotionTypes.setCustomPotionEffect(is, eff);
                is.func_77964_b(is.func_77960_j() | 0x4000);
                return is;
            }
            PotionEffect newEffect = null;
            if (ingredientItem == Items.field_151114_aO) {
                newEffect = new PotionEffect(eff.func_76456_a(), eff.func_76459_b(), eff.func_76458_c() + 1, eff.func_82720_e());
            } else if (ingredientItem == Items.field_151137_ax) {
                TimedPotion data = (TimedPotion)PotionTypes.getPotionData(is);
                newEffect = new PotionEffect(eff.func_76456_a(), Math.min(eff.func_76459_b() + data.getDurationStep(), data.maxDuration), eff.func_76458_c(), eff.func_82720_e());
            }
            if (newEffect != null) {
                PotionTypes.setCustomPotionEffect(is, newEffect);
            }
            return is;
        }
        byte[] byArray = indexes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            PotionEffect curEffect;
            Byte b = byArray[i];
            AbstractPotionData data = potionData.get(b.byteValue());
            if (data == null || data.requiredDamageValue != (is.func_77960_j() & 0xFFFFBFFF)) continue;
            PotionEffect prevEffect = PotionTypes.getEffectIfValid(is);
            ItemUtil.getTagRoot(is, false).func_82580_o("CustomPotionEffects");
            data.onFirstBrewingFinished(is);
            if (prevEffect == null || (curEffect = PotionTypes.getEffectIfValid(is)) == null) break;
            PotionTypes.setCustomPotionEffect(is, new PotionEffect(curEffect.func_76456_a(), prevEffect.func_76459_b(), prevEffect.func_76458_c(), prevEffect.func_82720_e()));
            break;
        }
        return is;
    }

    public static ItemStack setCustomPotionEffect(ItemStack is, PotionEffect effect) {
        NBTTagList potionList = new NBTTagList();
        potionList.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
        ItemUtil.getTagRoot(is, true).func_74782_a("CustomPotionEffects", (NBTBase)potionList);
        return is;
    }

    static {
        customPotions.put(ItemList.instability_orb, ItemList.potion_of_instability);
        customPotions.put(ItemList.ectoplasm, ItemList.potion_of_purity);
        customPotions.put(ItemList.silverfish_blood, ItemList.infestation_remedy);
        PotionTypes.mapItemToIndex(Items.field_151075_bm, 0);
        PotionTypes.mapItemToIndex(Items.field_151060_bw, 1);
        PotionTypes.mapItemToIndex(Items.field_151102_aT, 3);
        PotionTypes.mapItemToIndex(Items.field_151065_br, 5);
        PotionTypes.mapItemToIndex(Items.field_151150_bK, 7);
        PotionTypes.mapItemToIndex(Items.field_151073_bk, 9);
        PotionTypes.mapItemToIndex(Items.field_151070_bp, 10);
        PotionTypes.mapItemToIndex(Items.field_151064_bs, 11);
        PotionTypes.mapItemToIndex(Items.field_151115_aP, (Short)((short)ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 12);
        PotionTypes.mapItemToIndex(Items.field_151071_bq, 2, 4, 6, 8);
    }
}

