/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.element;

import chylex.hee.api.message.MessageRunner;
import chylex.hee.api.message.element.IntValue;
import chylex.hee.api.message.element.NbtValue;
import chylex.hee.api.message.element.StringValue;
import chylex.hee.api.message.element.base.Optional;
import chylex.hee.api.message.element.base.PreconditionComposite;
import com.google.common.base.Function;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.Pair;

public class ItemStackValue
extends PreconditionComposite<ItemStack> {
    public static final StringValue itemString = StringValue.function(new Function<String, Boolean>(){

        public Boolean apply(String input) {
            return ItemStackValue.getItemFromString(input) != null;
        }
    });

    public static final ItemStackValue any() {
        return new ItemStackValue();
    }

    public static final Pair<String, String> parseItemName(String fullName) {
        String modid = "minecraft";
        String name = "";
        int colon = fullName.indexOf(58);
        if (colon == -1) {
            name = fullName;
        } else {
            modid = fullName.substring(0, colon);
            name = fullName.substring(colon + 1);
            if (modid.equals("~hee")) {
                modid = "HardcoreEnderExpansion";
            }
        }
        return Pair.of((Object)modid, (Object)name);
    }

    public static final Item getItemFromString(String input) {
        Block block = null;
        Item item = null;
        Pair<String, String> name = ItemStackValue.parseItemName(input);
        item = GameRegistry.findItem((String)((String)name.getLeft()), (String)((String)name.getRight()));
        if (item != null) {
            return item;
        }
        block = GameRegistry.findBlock((String)((String)name.getLeft()), (String)((String)name.getRight()));
        if (block != null) {
            return Item.func_150898_a((Block)block);
        }
        return null;
    }

    private ItemStackValue() {
        this.addCondition("id", itemString);
        this.addCondition("damage", Optional.of(IntValue.range(0, Short.MAX_VALUE), 0));
        this.addCondition("count", Optional.of(IntValue.range(1, 64), 1));
        this.addCondition("tag", Optional.of(NbtValue.any(), new NBTTagCompound()));
    }

    @Override
    public ItemStack getValue(MessageRunner runner) {
        ItemStack is = new ItemStack(ItemStackValue.getItemFromString(runner.getString("id")));
        if (is.func_77973_b() == null) {
            throw new IllegalStateException("Failed constructing an ItemStack from IMC, item is null.");
        }
        is.func_77964_b(runner.getInt("damage"));
        is.field_77994_a = runner.getInt("count");
        NBTTagCompound tag = (NBTTagCompound)runner.getValue("tag");
        if (!tag.func_82582_d()) {
            is.func_77982_d(tag);
        }
        return is;
    }
}

