/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.newtypes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class DataForcedChunks
implements ISerializable {
    private static final CachedString NONE_CACHED = new CachedString("N/A");
    public int dim;
    public CachedString dimName;
    public CachedString modId;
    public CachedString playerOrEntityName;
    public CachedString rawData;
    public int numChunks;
    public CachedString chunks;
    public CachedString position;
    public CachedString type;

    public static List<DataForcedChunks> getAll(int dim) {
        WorldServer world = DimensionManager.getWorld((int)dim);
        ArrayList<DataForcedChunks> dataList = new ArrayList<DataForcedChunks>();
        String dimNameStr = world.field_73011_w.func_80007_l();
        CachedString dimName = dimNameStr != null ? new CachedString(dimNameStr) : NONE_CACHED;
        ImmutableSetMultimap ticketMap = world.getPersistentChunks();
        HashSet tickets = new HashSet(ticketMap.values());
        for (ForgeChunkManager.Ticket ticket : tickets) {
            DataForcedChunks data = new DataForcedChunks();
            dataList.add(data);
            data.dim = dim;
            data.dimName = dimName;
            data.modId = ticket.getModId() != null ? new CachedString(ticket.getModId()) : NONE_CACHED;
            if (ticket.isPlayerTicket()) {
                data.playerOrEntityName = new CachedString(ticket.getPlayerName());
            } else if (ticket.getType() == ForgeChunkManager.Type.ENTITY && ticket.getEntity() != null) {
                Entity entity = ticket.getEntity();
                data.playerOrEntityName = new CachedString(entity.getClass().getSimpleName());
            } else {
                data.playerOrEntityName = NONE_CACHED;
            }
            NBTTagCompound rawData = ticket.getModData();
            data.rawData = new CachedString(rawData.toString());
            data.tryParseLocation(rawData);
            data.tryParseType(rawData);
            StringBuilder sb = new StringBuilder();
            ImmutableSet chunkSet = ticket.getChunkList();
            Iterator itr = chunkSet.iterator();
            while (itr.hasNext()) {
                ChunkCoordIntPair coord = (ChunkCoordIntPair)itr.next();
                sb.append("(");
                sb.append(coord.field_77276_a);
                sb.append(",");
                sb.append(coord.field_77275_b);
                sb.append(")");
                if (!itr.hasNext()) continue;
                sb.append(", ");
            }
            data.numChunks = chunkSet.size();
            data.chunks = new CachedString(sb.toString());
        }
        return dataList;
    }

    private void tryParseLocation(NBTTagCompound raw) {
        if (raw.func_150297_b("address", 8)) {
            Integer chunkX = null;
            Integer chunkZ = null;
            if (raw.func_150297_b("x", 3)) {
                chunkX = raw.func_74762_e("x");
            }
            if (raw.func_150297_b("z", 3)) {
                chunkZ = raw.func_74762_e("z");
            }
            if (chunkX != null && chunkZ != null) {
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(chunkX.intValue(), chunkZ.intValue());
                this.position = new CachedString(String.format("[ %4d ? %4d ]", chunkPos.func_77273_a(), chunkPos.func_77274_b()));
                return;
            }
        }
        Integer xCoord = null;
        Integer yCoord = null;
        Integer zCoord = null;
        if (raw.func_150297_b("xCoord", 3)) {
            xCoord = raw.func_74762_e("xCoord");
        } else if (raw.func_150297_b("OwnerX", 3)) {
            xCoord = raw.func_74762_e("OwnerX");
        } else if (raw.func_150297_b("x", 3)) {
            xCoord = raw.func_74762_e("x");
        } else if (raw.func_150297_b("poppetX", 3)) {
            xCoord = raw.func_74762_e("poppetX");
        } else if (raw.func_150297_b("ChunkLoaderTileX", 3)) {
            xCoord = raw.func_74762_e("ChunkLoaderTileX");
        }
        if (raw.func_150297_b("yCoord", 3)) {
            yCoord = raw.func_74762_e("yCoord");
        } else if (raw.func_150297_b("OwnerY", 3)) {
            yCoord = raw.func_74762_e("OwnerY");
        } else if (raw.func_150297_b("y", 3)) {
            yCoord = raw.func_74762_e("y");
        } else if (raw.func_150297_b("poppetY", 3)) {
            yCoord = raw.func_74762_e("poppetY");
        } else if (raw.func_150297_b("ChunkLoaderTileY", 3)) {
            yCoord = raw.func_74762_e("ChunkLoaderTileY");
        }
        if (raw.func_150297_b("zCoord", 3)) {
            zCoord = raw.func_74762_e("zCoord");
        } else if (raw.func_150297_b("OwnerZ", 3)) {
            zCoord = raw.func_74762_e("OwnerZ");
        } else if (raw.func_150297_b("z", 3)) {
            zCoord = raw.func_74762_e("z");
        } else if (raw.func_150297_b("poppetZ", 3)) {
            zCoord = raw.func_74762_e("poppetZ");
        } else if (raw.func_150297_b("ChunkLoaderTileZ", 3)) {
            zCoord = raw.func_74762_e("ChunkLoaderTileZ");
        }
        if (xCoord == null && yCoord == null && zCoord == null) {
            this.position = NONE_CACHED;
            return;
        }
        String position = String.format("[ %s %s %s ]", xCoord == null ? "?" : String.format("%4d", xCoord), yCoord == null ? "?" : String.format("%4d", yCoord), zCoord == null ? "?" : String.format("%4d", zCoord));
        this.position = new CachedString(position);
    }

    private void tryParseType(NBTTagCompound raw) {
        String type = null;
        if (raw.func_150297_b("type", 8)) {
            type = raw.func_74779_i("type");
        } else if (raw.func_150297_b("id", 8)) {
            type = raw.func_74779_i("id");
        } else if (raw.func_150297_b("townName", 8)) {
            type = "Town: " + raw.func_74779_i("townName");
        } else if (raw.func_150297_b("poppetX", 3)) {
            type = "Poppet";
        } else if (raw.func_150297_b("OwnerType", 8)) {
            type = raw.func_74779_i("OwnerType");
        }
        this.type = type != null ? new CachedString(type) : NONE_CACHED;
    }

    @Override
    public void writeToStream(ByteArrayDataOutput stream) {
        stream.writeInt(this.dim);
        this.dimName.writeToStream(stream);
        this.modId.writeToStream(stream);
        this.playerOrEntityName.writeToStream(stream);
        this.position.writeToStream(stream);
        this.type.writeToStream(stream);
        this.rawData.writeToStream(stream);
        stream.writeInt(this.numChunks);
        this.chunks.writeToStream(stream);
    }

    public static DataForcedChunks readFromStream(ByteArrayDataInput stream) {
        DataForcedChunks retVal = new DataForcedChunks();
        retVal.dim = stream.readInt();
        retVal.dimName = CachedString.readFromStream(stream);
        retVal.modId = CachedString.readFromStream(stream);
        retVal.playerOrEntityName = CachedString.readFromStream(stream);
        retVal.position = CachedString.readFromStream(stream);
        retVal.type = CachedString.readFromStream(stream);
        retVal.rawData = CachedString.readFromStream(stream);
        retVal.numChunks = stream.readInt();
        retVal.chunks = CachedString.readFromStream(stream);
        return retVal;
    }
}

