/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.translocator.TileItemTranslocator;
import codechicken.translocator.TileLiquidTranslocator;
import codechicken.translocator.TileTranslocator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockTranslocator
extends Block {
    private final RayTracer rayTracer = new RayTracer();

    public BlockTranslocator() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public boolean hasTileEntity(int metadata) {
        return metadata < 2;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileItemTranslocator();
            }
            case 1: {
                return new TileLiquidTranslocator();
            }
        }
        return null;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public static boolean canExistOnSide(World world, int x, int y, int z, int side, int meta) {
        BlockCoord pos = new BlockCoord(x, y, z).offset(side);
        switch (meta) {
            case 0: {
                return world.func_147438_o(pos.x, pos.y, pos.z) instanceof IInventory;
            }
            case 1: {
                return world.func_147438_o(pos.x, pos.y, pos.z) instanceof IFluidHandler;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileTranslocator ttrans = (TileTranslocator)world.func_147438_o(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        for (int i = 0; i < 6 && (ttrans.attachments[i] == null || BlockTranslocator.canExistOnSide(world, x, y, z, i, meta) || !ttrans.harvestPart(i, true)); ++i) {
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willharvest) {
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        if (hit == null) {
            return false;
        }
        TileTranslocator ttrans = (TileTranslocator)world.func_147438_o(x, y, z);
        return ttrans.harvestPart(hit.subHit % 6, !player.field_71075_bZ.field_75098_d);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int md, int fortune) {
        ArrayList<ItemStack> ai = new ArrayList<ItemStack>();
        if (world.field_72995_K) {
            return ai;
        }
        TileTranslocator ttrans = (TileTranslocator)world.func_147438_o(x, y, z);
        if (ttrans != null) {
            for (TileTranslocator.Attachment a : ttrans.attachments) {
                if (a == null) continue;
                ai.addAll(a.getDrops());
            }
        }
        return ai;
    }

    public IIcon func_149691_a(int par1, int par2) {
        return Blocks.field_150343_Z.func_149691_a(par1, par2);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), this.getParts(world, x, y, z), new BlockCoord(x, y, z), (Block)this);
    }

    public List<IndexedCuboid6> getParts(World world, int x, int y, int z) {
        TileTranslocator tile = (TileTranslocator)world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        tile.addTraceableCuboids(cuboids);
        return cuboids;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB ebb, List list, Entity entity) {
        List<IndexedCuboid6> cuboids = this.getParts(world, x, y, z);
        for (IndexedCuboid6 cb : cuboids) {
            AxisAlignedBB aabb = cb.toAABB();
            if (!aabb.func_72326_a(ebb)) continue;
            list.add(aabb);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        TileTranslocator ttrans = (TileTranslocator)world.func_147438_o(x, y, z);
        if (hit != null) {
            if (hit.subHit < 6) {
                Vector3 vhit = new Vector3(hit.field_72307_f);
                vhit.add((double)(-x) - 0.5, (double)(-y) - 0.5, (double)(-z) - 0.5);
                vhit.apply((Transformation)Rotation.sideRotations[hit.subHit % 6].inverse());
                if (MathHelper.between((double)-0.125, (double)vhit.x, (double)0.125) && MathHelper.between((double)-0.125, (double)vhit.z, (double)0.125)) {
                    hit.subHit += 6;
                }
            }
            return ttrans.attachments[hit.subHit % 6].activate(player, hit.subHit / 6);
        }
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack((Block)this, 1, 0));
        list.add(new ItemStack((Block)this, 1, 1));
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileTranslocator ttrans = (TileTranslocator)world.func_147438_o(x, y, z);
        return ttrans.connectRedstone();
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileTranslocator ttrans = (TileTranslocator)world.func_147438_o(x, y, z);
        return ttrans.strongPowerLevel(side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    public class EventHandler {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onBlockHighlight(DrawBlockHighlightEvent event) {
            if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) == BlockTranslocator.this) {
                RayTracer.retraceBlock((World)event.player.field_70170_p, (EntityPlayer)event.player, (int)event.target.field_72311_b, (int)event.target.field_72312_c, (int)event.target.field_72309_d);
            }
        }
    }
}

