/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.gregtech;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.items.ItemRadioactiveCell;
import gregtech.api.items.ItemRadioactiveCellIC;
import net.minecraft.item.ItemStack;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;

public class CrossGregTech {
    private boolean _isApiAvailable;

    public CrossGregTech() {
        if (Loader.isModLoaded((String)"gregtech")) {
            this._isApiAvailable = true;
            IC2NuclearControl.logger.info("[IC2NuclearControl] find GregTech");
        } else {
            this._isApiAvailable = false;
        }
    }

    public boolean isApiAvailable() {
        return this._isApiAvailable;
    }

    public int getNuclearCellTimeLeft(ItemStack stack) {
        if (!this._isApiAvailable || stack == null) {
            return 0;
        }
        try {
            if (stack.func_77973_b() instanceof ItemRadioactiveCellIC) {
                int currentDmg;
                String rodName = stack.func_77977_a();
                ItemRadioactiveCell rod = (ItemRadioactiveCell)GameRegistry.findItem((String)"gregtech", (String)rodName);
                int maxDamage = rod.getMaxDamageEx();
                int dmg = maxDamage - (currentDmg = ItemRadioactiveCellIC.getDurabilityOfStack((ItemStack)stack));
                return dmg > 0 ? dmg : 0;
            }
            return -1;
        }
        catch (Exception e) {
            IC2NuclearControl.logger.error((Object)e);
            return -1;
        }
    }
}

