/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.iterators.NullIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class AdaptorPlayerHand
extends InventoryAdaptor {
    private final EntityPlayer player;

    public AdaptorPlayerHand(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        ItemStack hand = this.player.field_71071_by.func_70445_o();
        if (hand == null) {
            return null;
        }
        if (filter == null || Platform.isSameItemPrecise(filter, hand)) {
            ItemStack result = hand.func_77946_l();
            result.field_77994_a = hand.field_77994_a > amount ? amount : hand.field_77994_a;
            hand.field_77994_a -= amount;
            if (hand.field_77994_a <= 0) {
                this.player.field_71071_by.func_70437_b(null);
            }
            return result;
        }
        return null;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        ItemStack hand = this.player.field_71071_by.func_70445_o();
        if (hand == null) {
            return null;
        }
        if (filter == null || Platform.isSameItemPrecise(filter, hand)) {
            ItemStack result = hand.func_77946_l();
            result.field_77994_a = hand.field_77994_a > amount ? amount : hand.field_77994_a;
            return result;
        }
        return null;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack hand = this.player.field_71071_by.func_70445_o();
        if (hand == null) {
            return null;
        }
        if (filter == null || Platform.isSameItemFuzzy(filter, hand, fuzzyMode)) {
            ItemStack result = hand.func_77946_l();
            result.field_77994_a = hand.field_77994_a > amount ? amount : hand.field_77994_a;
            hand.field_77994_a -= amount;
            if (hand.field_77994_a <= 0) {
                this.player.field_71071_by.func_70437_b(null);
            }
            return result;
        }
        return null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack hand = this.player.field_71071_by.func_70445_o();
        if (hand == null) {
            return null;
        }
        if (filter == null || Platform.isSameItemFuzzy(filter, hand, fuzzyMode)) {
            ItemStack result = hand.func_77946_l();
            result.field_77994_a = hand.field_77994_a > amount ? amount : hand.field_77994_a;
            return result;
        }
        return null;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        if (toBeAdded == null) {
            return null;
        }
        if (toBeAdded.field_77994_a == 0) {
            return null;
        }
        if (this.player == null) {
            return toBeAdded;
        }
        if (this.player.field_71071_by == null) {
            return toBeAdded;
        }
        ItemStack hand = this.player.field_71071_by.func_70445_o();
        if (hand != null && !Platform.isSameItemPrecise(toBeAdded, hand)) {
            return toBeAdded;
        }
        int original = 0;
        ItemStack newHand = null;
        if (hand == null) {
            newHand = toBeAdded.func_77946_l();
        } else {
            newHand = hand;
            original = hand.field_77994_a;
            newHand.field_77994_a += toBeAdded.field_77994_a;
        }
        if (newHand.field_77994_a > newHand.func_77976_d()) {
            newHand.field_77994_a = newHand.func_77976_d();
            ItemStack B = toBeAdded.func_77946_l();
            B.field_77994_a -= newHand.field_77994_a - original;
            this.player.field_71071_by.func_70437_b(newHand);
            return B;
        }
        this.player.field_71071_by.func_70437_b(newHand);
        return null;
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        ItemStack hand = this.player.field_71071_by.func_70445_o();
        if (toBeSimulated == null) {
            return null;
        }
        if (hand != null && !Platform.isSameItem(toBeSimulated, hand)) {
            return toBeSimulated;
        }
        int original = 0;
        ItemStack newHand = null;
        if (hand == null) {
            newHand = toBeSimulated.func_77946_l();
        } else {
            newHand = hand.func_77946_l();
            original = hand.field_77994_a;
            newHand.field_77994_a += toBeSimulated.field_77994_a;
        }
        if (newHand.field_77994_a > newHand.func_77976_d()) {
            newHand.field_77994_a = newHand.func_77976_d();
            ItemStack B = toBeSimulated.func_77946_l();
            B.field_77994_a -= newHand.field_77994_a - original;
            return B;
        }
        return null;
    }

    @Override
    public boolean containsItems() {
        return this.player.field_71071_by.func_70445_o() != null;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new NullIterator<ItemSlot>();
    }
}

