/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util;

import com.github.dcysteine.neicustomdiagram.api.Formatter;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class FluidDictUtil {
    public static final java.util.function.Supplier<ImmutableList<FluidContainerRegistry.FluidContainerData>> FORGE_FLUID_CONTAINER_DATA_SUPPLIER = () -> ((Supplier)Suppliers.memoize(() -> ImmutableList.copyOf((Object[])FluidContainerRegistry.getRegisteredFluidContainerData()))).get();

    private FluidDictUtil() {
    }

    public static Optional<ItemComponent> fluidToItem(Component component) {
        if (component.type() != Component.ComponentType.FLUID) {
            return Optional.empty();
        }
        return ItemComponent.create(((FluidComponent)component).fluid().getBlock(), 0);
    }

    public static Optional<FluidComponent> itemToFluid(Component component) {
        if (component.type() != Component.ComponentType.ITEM) {
            return Optional.empty();
        }
        Block block = Block.func_149634_a((Item)((ItemComponent)component).item());
        if (block == null) {
            return Optional.empty();
        }
        return FluidComponent.create(block);
    }

    public static Optional<FluidComponent> getFluidContents(Component component) {
        switch (component.type()) {
            case ITEM: {
                Optional<FluidComponent> fluidOptional = FluidDictUtil.itemToFluid(component);
                if (fluidOptional.isPresent()) {
                    return fluidOptional;
                }
                FluidStack containedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)component.stack()));
                if (containedFluid != null) {
                    return Optional.of(FluidComponent.create(containedFluid));
                }
                return Optional.empty();
            }
            case FLUID: {
                return Optional.of((FluidComponent)component);
            }
        }
        return Optional.empty();
    }

    public static DisplayComponent displayFluidContainer(FluidContainerRegistry.FluidContainerData data) {
        int capacity = data.fluid.amount;
        return DisplayComponent.builder(data.filledContainer).clearStackSize().setAdditionalInfo(Formatter.smartFormatInteger(capacity)).setAdditionalTooltip(Tooltip.builder().setFormatting(Tooltip.INFO_FORMATTING).addTextLine(Lang.UTIL.transf("capacity", capacity)).addSpacing().addTextLine(Lang.UTIL.transf("fluidcontainercontents", new Object[0])).addDisplayComponent(DisplayComponent.builder(data.fluid).build()).addSpacing().addTextLine(Lang.UTIL.transf("emptyfluidcontainer", new Object[0])).addComponent(ItemComponent.create(data.emptyContainer)).build()).build();
    }

    public static List<DisplayComponent> getFluidContainers(Component component) {
        Optional<FluidComponent> fluidOptional = FluidDictUtil.getFluidContents(component);
        ArrayList<DisplayComponent> results = new ArrayList<DisplayComponent>();
        if (fluidOptional.isPresent()) {
            results.add(DisplayComponent.builder(fluidOptional.get()).build());
            Fluid fluid = fluidOptional.get().fluid();
            for (FluidContainerRegistry.FluidContainerData data : FORGE_FLUID_CONTAINER_DATA_SUPPLIER.get()) {
                if (fluid != data.fluid.getFluid()) continue;
                results.add(FluidDictUtil.displayFluidContainer(data));
            }
        }
        return results;
    }

    public static Optional<ItemComponent> getEmptyContainer(Component component) {
        if (component.type() != Component.ComponentType.ITEM) {
            return Optional.empty();
        }
        ItemComponent itemComponent = (ItemComponent)component;
        ItemStack itemStack = itemComponent.stack();
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
            return Optional.of(itemComponent);
        }
        ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)itemStack);
        return Optional.ofNullable(emptyContainer).map(ItemComponent::create);
    }
}

