/*
 * Decompiled with CFR 0.152.
 */
package serverutils.watchdog;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import serverutils.watchdog.IMaxTickTimeDedicatedServer;
import serverutils.watchdog.IMaxTickTimeMinecraftServer;

@SideOnly(value=Side.SERVER)
public class ServerHangWatchdog
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DedicatedServer server;
    private final long maxTickTime;

    public ServerHangWatchdog(DedicatedServer server) {
        this.server = server;
        this.maxTickTime = ((IMaxTickTimeDedicatedServer)server).serverutilities$getMaxTickTime();
    }

    @Override
    public void run() {
        while (this.server.func_71278_l()) {
            long i = ((IMaxTickTimeMinecraftServer)this.server).serverutilities$getCurrentTime();
            long j = MinecraftServer.func_130071_aq();
            long k = j - i;
            if (k > this.maxTickTime) {
                LOGGER.fatal("A single server tick took {} seconds (should be max {})", new Object[]{String.format("%.2f", Float.valueOf((float)k / 1000.0f)), String.format("%.2f", Float.valueOf(0.05f))});
                LOGGER.fatal("Considering it to be crashed, server will forcibly shutdown.");
                ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
                StringBuilder stringbuilder = new StringBuilder();
                Error error = new Error(String.format("ServerHangWatchdog detected that a single server tick took %.2f seconds (should be max 0.05)", Float.valueOf((float)k / 1000.0f)));
                for (ThreadInfo threadinfo : athreadinfo) {
                    if (Objects.equals(threadinfo.getThreadName(), "Server thread")) {
                        error.setStackTrace(threadinfo.getStackTrace());
                    }
                    stringbuilder.append(threadinfo);
                    stringbuilder.append("\n");
                }
                CrashReport crashreport = new CrashReport("Watching Server", (Throwable)error);
                this.server.func_71230_b(crashreport);
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Thread Dump");
                crashreportcategory.func_71507_a("Threads", (Object)stringbuilder);
                File file1 = new File(new File(this.server.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
                if (crashreport.func_147149_a(file1)) {
                    LOGGER.error("This crash report has been saved to: {}", new Object[]{file1.getAbsolutePath()});
                } else {
                    LOGGER.error("We were unable to save this crash report to disk.");
                }
                this.scheduleHalt();
            }
            try {
                Thread.sleep(i + this.maxTickTime - j);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void scheduleHalt() {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    FMLCommonHandler.instance().exitJava(1, true);
                }
            }, 10000L);
            FMLCommonHandler.instance().exitJava(1, false);
        }
        catch (Throwable var2) {
            FMLCommonHandler.instance().exitJava(1, true);
        }
    }
}

