/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ItemIcon;

public class MainInventory
implements IModdedInventory {
    private static final Icon CHEST_ICON = ItemIcon.getItemIcon((Block)Blocks.field_150486_ae);

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        return player.field_71071_by;
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        NBTTagCompound tag = player.getPlayerNBT();
        InventoryPlayer playerInv = new InventoryPlayer(null);
        playerInv.func_70443_b(tag.func_150295_c("Inventory", 10));
        return playerInv;
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        return new InventoryPlayer(player);
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return CHEST_ICON;
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "Main Inventory";
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        if (player.isOnline()) {
            return;
        }
        NBTTagCompound tag = player.getPlayerNBT();
        InventoryPlayer invPlayer = (InventoryPlayer)inventory;
        NBTTagList invTag = new NBTTagList();
        invPlayer.func_70442_a(invTag);
        tag.func_74782_a("Inventory", (NBTBase)invTag);
        player.setPlayerNBT(tag);
    }

    @Override
    @Nullable
    public Slot getSlot(EntityPlayer player, IInventory inventory, int index, int x, int y) {
        if (index >= inventory.func_70302_i_() - 4) {
            int armorSlot = this.getArmorSlotIndex(index, inventory);
            return new SlotArmor(inventory, armorSlot, x, y, player, inventory.func_70302_i_() - 1 - armorSlot);
        }
        if (index >= 9 && index < 18) {
            index += 18;
        } else if (index >= 27 && index < 36) {
            index -= 18;
        }
        return new Slot(inventory, index, x, y);
    }

    public int getArmorSlotIndex(int index, IInventory inventory) {
        if (index == inventory.func_70302_i_() - 4) {
            return inventory.func_70302_i_() - 1;
        }
        if (index == inventory.func_70302_i_() - 3) {
            return inventory.func_70302_i_() - 2;
        }
        if (index == inventory.func_70302_i_() - 2) {
            return inventory.func_70302_i_() - 3;
        }
        return inventory.func_70302_i_() - 4;
    }

    private static class SlotArmor
    extends Slot {
        private final int armorSlot;
        private final EntityPlayer player;

        private SlotArmor(IInventory inventory, int index, int x, int y, EntityPlayer player, int armorSlot) {
            super(inventory, index, x, y);
            this.player = player;
            this.armorSlot = armorSlot;
        }

        public int func_75219_a() {
            return 1;
        }

        public boolean func_75214_a(@Nullable ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return stack.func_77973_b().isValidArmor(stack, this.armorSlot, (Entity)this.player);
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon func_75212_b() {
            return ItemArmor.func_94602_b((int)this.armorSlot);
        }
    }
}

