/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import com.darkona.adventurebackpack.inventory.IInventoryTanks;
import com.darkona.adventurebackpack.inventory.InventoryBackpack;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.Wearing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ItemIcon;

public class AdventureBackpackInv
implements IModdedInventory {
    private static final Icon BACKPACK_ICON = ItemIcon.getItemIcon(BackpackUtils.createBackpackStack((BackpackTypes)BackpackTypes.RAINBOW));
    private static final String WEARABLE_TAG = "wearable";

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        if (!Wearing.isWearingBackpack((EntityPlayer)player)) {
            return null;
        }
        return Wearing.getWearingBackpackInv((EntityPlayer)player);
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        NBTTagCompound backpackTag = player.getPlayerNBT();
        if (!backpackTag.func_74764_b(WEARABLE_TAG)) {
            return null;
        }
        ItemStack wearable = ItemStack.func_77949_a((NBTTagCompound)backpackTag.func_74775_l(WEARABLE_TAG));
        if (wearable == null || !(wearable.func_77973_b() instanceof ItemAdventureBackpack)) {
            return null;
        }
        return new InventoryBackpack(wearable);
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        return new InventoryBasic("", false, size);
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return BACKPACK_ICON;
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "Adventure Backpack";
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        if (player.isOnline()) {
            return;
        }
        NBTTagCompound tag = player.getPlayerNBT();
        inventory.func_70305_f();
        tag.func_74782_a(WEARABLE_TAG, (NBTBase)((IInventoryTanks)inventory).getParentItem().func_77955_b(new NBTTagCompound()));
        player.setPlayerNBT(tag);
    }
}

