/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.module.inpipe;

import java.io.IOException;
import logisticspipes.gui.GuiCraftingPipe;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class CraftingModuleSlot
extends ModuleCoordinatesGuiProvider {
    private boolean isAdvancedSat;
    private int liquidCrafter;
    private int[] amount;
    private boolean hasByproductExtractor;
    private boolean isFuzzy;
    private int cleanupSize;
    private boolean cleanupExclude;

    public CraftingModuleSlot(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        ModuleCrafter module = this.getLogisticsModule(player.func_130014_f_(), ModuleCrafter.class);
        if (module == null) {
            return null;
        }
        return new GuiCraftingPipe(player, module.getDummyInventory(), module, this.isAdvancedSat, this.liquidCrafter, this.amount, this.hasByproductExtractor, this.isFuzzy, this.cleanupSize, this.cleanupExclude);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        ModuleCrafter module = this.getLogisticsModule(player.func_130014_f_(), ModuleCrafter.class);
        if (module == null) {
            return null;
        }
        MainProxy.sendPacketToPlayer(module.getCPipePacket(), player);
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, module.getDummyInventory());
        dummy.addNormalSlotsForPlayerInventory(18, 97);
        for (int l = 0; l < 9; ++l) {
            dummy.addFuzzyDummySlot(l, 18 + l * 18, 18, module.fuzzyCraftingFlagArray[l]);
        }
        dummy.addFuzzyDummySlot(9, 90, 64, module.outputFuzzyFlags);
        for (int i = 0; i < this.liquidCrafter; ++i) {
            int liquidLeft = -(i * 40) - 40;
            dummy.addFluidSlot(i, module.getFluidInventory(), liquidLeft + 13, 42);
        }
        if (this.hasByproductExtractor) {
            dummy.addDummySlot(10, 197, 104);
        }
        for (int Y = 0; Y < this.cleanupSize; ++Y) {
            for (int X = 0; X < 3; ++X) {
                dummy.addDummySlot(Y * 3 + X, module.getCleanupInventory(), X * 18 - 57, Y * 18 + 13);
            }
        }
        return dummy;
    }

    @Override
    public GuiProvider template() {
        return new CraftingModuleSlot(this.getId());
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.isAdvancedSat);
        data.writeInt(this.liquidCrafter);
        data.writeIntegerArray(this.amount);
        data.writeBoolean(this.hasByproductExtractor);
        data.writeBoolean(this.isFuzzy);
        data.writeInt(this.cleanupSize);
        data.writeBoolean(this.cleanupExclude);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.isAdvancedSat = data.readBoolean();
        this.liquidCrafter = data.readInt();
        this.amount = data.readIntegerArray();
        this.hasByproductExtractor = data.readBoolean();
        this.isFuzzy = data.readBoolean();
        this.cleanupSize = data.readInt();
        this.cleanupExclude = data.readBoolean();
    }

    public boolean isAdvancedSat() {
        return this.isAdvancedSat;
    }

    public CraftingModuleSlot setAdvancedSat(boolean isAdvancedSat) {
        this.isAdvancedSat = isAdvancedSat;
        return this;
    }

    public int getLiquidCrafter() {
        return this.liquidCrafter;
    }

    public CraftingModuleSlot setLiquidCrafter(int liquidCrafter) {
        this.liquidCrafter = liquidCrafter;
        return this;
    }

    public int[] getAmount() {
        return this.amount;
    }

    public CraftingModuleSlot setAmount(int[] amount) {
        this.amount = amount;
        return this;
    }

    public boolean isHasByproductExtractor() {
        return this.hasByproductExtractor;
    }

    public CraftingModuleSlot setHasByproductExtractor(boolean hasByproductExtractor) {
        this.hasByproductExtractor = hasByproductExtractor;
        return this;
    }

    public boolean isFuzzy() {
        return this.isFuzzy;
    }

    public CraftingModuleSlot setFuzzy(boolean isFuzzy) {
        this.isFuzzy = isFuzzy;
        return this;
    }

    public int getCleanupSize() {
        return this.cleanupSize;
    }

    public CraftingModuleSlot setCleanupSize(int cleanupSize) {
        this.cleanupSize = cleanupSize;
        return this;
    }

    public boolean isCleanupExclude() {
        return this.cleanupExclude;
    }

    public CraftingModuleSlot setCleanupExclude(boolean cleanupExclude) {
        this.cleanupExclude = cleanupExclude;
        return this;
    }
}

