/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import logisticspipes.network.IReadListObject;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ResourceNetwork;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.order.ClientSideOrderInfo;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LPDataInputStream
extends DataInputStream {
    public LPDataInputStream(byte[] inputBytes) {
        super(new ByteArrayInputStream(inputBytes));
    }

    public LPDataInputStream(ByteBuf inputBytes) {
        super((InputStream)new ByteBufInputStream(inputBytes));
    }

    public ForgeDirection readForgeDirection() throws IOException {
        int dir = this.in.read();
        if (dir == 10) {
            return null;
        }
        return ForgeDirection.values()[dir];
    }

    public ExitRoute readExitRoute(World world) throws IOException {
        IRouter destination = this.readIRouter(world);
        IRouter root = this.readIRouter(world);
        ForgeDirection exitOri = this.readForgeDirection();
        ForgeDirection insertOri = this.readForgeDirection();
        EnumSet<PipeRoutingConnectionType> connectionDetails = this.readEnumSet(PipeRoutingConnectionType.class);
        double distanceToDestination = this.readDouble();
        double destinationDistanceToRoot = this.readDouble();
        int blockDistance = this.readInt();
        List<LPPosition> positions = this.readList(LPDataInputStream::readLPPosition);
        ExitRoute e = new ExitRoute(root, destination, exitOri, insertOri, destinationDistanceToRoot, connectionDetails, blockDistance);
        e.distanceToDestination = distanceToDestination;
        e.debug.filterPosition = positions;
        e.debug.toStringNetwork = this.readUTF();
        e.debug.isNewlyAddedCanidate = this.readBoolean();
        e.debug.isTraced = this.readBoolean();
        e.debug.index = this.readInt();
        return e;
    }

    public IRouter readIRouter(World world) throws IOException {
        if (this.in.read() == 0) {
            return null;
        }
        LPPosition pos = this.readLPPosition();
        TileEntity tile = pos.getTileEntity(world);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe) {
            return ((CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe).getRouter();
        }
        return null;
    }

    public LPPosition readLPPosition() throws IOException {
        return new LPPosition(this.readDouble(), this.readDouble(), this.readDouble());
    }

    public <T extends Enum<T>> EnumSet<T> readEnumSet(Class<T> clazz) throws IOException {
        EnumSet<T> types = EnumSet.noneOf(clazz);
        Enum[] parts = (Enum[])clazz.getEnumConstants();
        int length = this.in.read();
        byte[] set = new byte[length];
        this.in.read(set);
        for (Enum part : parts) {
            if ((set[part.ordinal() / 8] & 1 << part.ordinal() % 8) == 0) continue;
            types.add(part);
        }
        return types;
    }

    public BitSet readBitSet() throws IOException {
        byte size = this.readByte();
        byte[] bytes = new byte[size];
        this.read(bytes);
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public NBTTagCompound readNBTTagCompound() throws IOException {
        short legth = this.readShort();
        if (legth < 0) {
            return null;
        }
        byte[] array = new byte[legth];
        this.readFully(array);
        return CompressedStreamTools.func_152457_a((byte[])array, (NBTSizeTracker)new NBTSizeTracker(Long.MAX_VALUE));
    }

    public boolean[] readBooleanArray() throws IOException {
        boolean[] array = new boolean[this.readInt()];
        BitSet set = this.readBitSet();
        for (int i = 0; i < array.length; ++i) {
            array[i] = set.get(i);
        }
        return array;
    }

    public int[] readIntegerArray() throws IOException {
        int[] array = new int[this.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public ItemIdentifier readItemIdentifier() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int itemID = this.readInt();
        int damage = this.readInt();
        NBTTagCompound tag = this.readNBTTagCompound();
        return ItemIdentifier.get(Item.func_150899_d((int)itemID), damage, tag);
    }

    public ItemIdentifierStack readItemIdentifierStack() throws IOException {
        ItemIdentifier item = this.readItemIdentifier();
        int stacksize = this.readInt();
        return new ItemIdentifierStack(item, stacksize);
    }

    public <T> List<T> readList(IReadListObject<T> handler) throws IOException {
        int size = this.readInt();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(handler.readObject(this));
        }
        return list;
    }

    public IOrderInfoProvider readOrderInfo() throws IOException {
        ItemIdentifierStack stack = this.readItemIdentifierStack();
        int routerId = this.readInt();
        boolean isFinished = this.readBoolean();
        boolean inProgress = this.readBoolean();
        IOrderInfoProvider.ResourceType type = this.readEnum(IOrderInfoProvider.ResourceType.class);
        List<Float> list = this.readList(DataInputStream::readFloat);
        byte machineProgress = this.readByte();
        LPPosition pos = null;
        ItemIdentifier ident = null;
        if (this.readBoolean()) {
            pos = this.readLPPosition();
            ident = this.readItemIdentifier();
        }
        return new ClientSideOrderInfo(stack, isFinished, type, inProgress, routerId, list, machineProgress, pos, ident);
    }

    public <T extends Enum<T>> T readEnum(Class<T> clazz) throws IOException {
        return (T)((Enum[])clazz.getEnumConstants())[this.readInt()];
    }

    public LinkedLogisticsOrderList readLinkedLogisticsOrderList() throws IOException {
        LinkedLogisticsOrderList list = new LinkedLogisticsOrderList();
        list.addAll(this.readList(LPDataInputStream::readOrderInfo));
        list.getSubOrders().addAll(this.readList(LPDataInputStream::readLinkedLogisticsOrderList));
        return list;
    }

    public byte[] readByteArray() throws IOException {
        byte[] array = new byte[this.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readByte();
        }
        return array;
    }

    public ByteBuf readByteBuf() throws IOException {
        byte[] bytes = this.readByteArray();
        return Unpooled.copiedBuffer((byte[])bytes);
    }

    public long[] readLongArray() throws IOException {
        long[] array = new long[this.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public IResource readIResource() throws IOException {
        return ResourceNetwork.readResource(this);
    }
}

