/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.config;

import cpw.mods.fml.common.Loader;
import java.io.File;
import logisticspipes.LPConstants;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Configs {
    public static final String CATEGORY_MULTITHREAD = "multithread";
    public static final String CATEGORY_DEBUG = "debug";
    private static Configuration CONFIGURATION;
    public static int LOGISTICS_DETECTION_LENGTH;
    public static int LOGISTICS_DETECTION_COUNT;
    public static int LOGISTICS_DETECTION_FREQUENCY;
    public static boolean LOGISTICS_ORDERER_COUNT_INVERTWHEEL;
    public static boolean LOGISTICS_ORDERER_PAGE_INVERTWHEEL;
    public static final float LOGISTICS_ROUTED_SPEED_MULTIPLIER = 20.0f;
    public static final float LOGISTICS_DEFAULTROUTED_SPEED_MULTIPLIER = 10.0f;
    public static int MAX_UNROUTED_CONNECTIONS;
    public static int LOGISTICS_HUD_RENDER_DISTANCE;
    public static float pipeDurability;
    public static boolean LOGISTICS_POWER_USAGE_DISABLED;
    public static boolean ENABLE_RESEARCH_SYSTEM;
    public static boolean TOOLTIP_INFO;
    public static boolean MANDATORY_CARPENTER_RECIPES;
    public static boolean ENABLE_BETA_RECIPES;
    public static boolean ENABLE_PARTICLE_FX;
    public static boolean DISPLAY_POPUP;
    public static int MULTI_THREAD_NUMBER;
    public static int MULTI_THREAD_PRIORITY;
    public static double POWER_USAGE_MULTIPLIER;
    public static int LOGISTICS_CRAFTING_TABLE_POWER_USAGE;
    public static boolean CHECK_FOR_UPDATES;
    public static boolean EASTER_EGGS;
    public static boolean OPAQUE;
    public static int MAX_ROBOT_DISTANCE;
    public static int MAX_LOGISTICS_FLUID_TRANSPORT_INNER_CAPACITY;
    private static boolean loaded;

    public static void load() {
        if (loaded) {
            return;
        }
        if (Loader.instance().getConfigDir() == null) {
            return;
        }
        CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "LogisticsPipes.cfg"));
        CONFIGURATION.load();
        loaded = true;
        if (CONFIGURATION.hasCategory("logisticspipe.id") || CONFIGURATION.hasCategory("logisticsPipe.id")) {
            throw new RuntimeException("Old config, please remove it and manually reconfigure LogisticPipes");
        }
        LOGISTICS_DETECTION_LENGTH = CONFIGURATION.get("general", "detectionLength", LOGISTICS_DETECTION_LENGTH, "The maximum shortest length between logistics pipes. This is an indicator on the maxim depth of the recursion algorithm to discover logistics neighbours. A low value might use less CPU, a high value will allow longer pipe sections").getInt();
        LOGISTICS_DETECTION_COUNT = CONFIGURATION.get("general", "detectionCount", LOGISTICS_DETECTION_COUNT, "The maximum number of buildcraft pipes (including forks) between logistics pipes. This is an indicator of the maximum amount of nodes the recursion algorithm will visit before giving up. As it is possible to fork a pipe connection using standard BC pipes the algorithm will attempt to discover all available destinations through that pipe. Do note that the logistics system will not interfere with the operation of non-logistics pipes. So a forked pipe will usually be sup-optimal, but it is possible. A low value might reduce CPU usage, a high value will be able to handle more complex pipe setups. If you never fork your connection between the logistics pipes this has the same meaning as detectionLength and the lower of the two will be used").getInt();
        LOGISTICS_DETECTION_FREQUENCY = Math.max(CONFIGURATION.get("general", "reDetectionFrequency", LOGISTICS_DETECTION_FREQUENCY, "The amount of time that passes between checks to see if it is still connected to its neighbours (Independently from block place detection). A low value will mean that it will correct wrong values faster but use more CPU. A high value means error correction takes longer, but CPU consumption is reduced. A value of 20 will check about every second (default 600 [30 seconds])").getInt(), 1);
        MAX_ROBOT_DISTANCE = CONFIGURATION.get("general", "maxRobotDistance", MAX_ROBOT_DISTANCE, "The max. distance between two robots when there is no zone defined.").getInt();
        LOGISTICS_ORDERER_COUNT_INVERTWHEEL = CONFIGURATION.get("general", "ordererCountInvertWheel", LOGISTICS_ORDERER_COUNT_INVERTWHEEL, "Inverts the the mouse wheel scrolling for remote order number of items").getBoolean(false);
        LOGISTICS_ORDERER_PAGE_INVERTWHEEL = CONFIGURATION.get("general", "ordererPageInvertWheel", LOGISTICS_ORDERER_PAGE_INVERTWHEEL, "Inverts the the mouse wheel scrolling for remote order pages").getBoolean(false);
        LOGISTICS_POWER_USAGE_DISABLED = CONFIGURATION.get("general", "powerUsageDisabled", LOGISTICS_POWER_USAGE_DISABLED, "Disable the power usage trough LogisticsPipes").getBoolean(false);
        LOGISTICS_HUD_RENDER_DISTANCE = CONFIGURATION.get("general", "HUDRenderDistance", LOGISTICS_HUD_RENDER_DISTANCE, "The max. distance between a player and the HUD that get's shown in blocks.").getInt();
        DISPLAY_POPUP = CONFIGURATION.get("general", "displayPopup", DISPLAY_POPUP, "Set the default configuration for the popup of the Orderer Gui. Should it be used?").getBoolean(false);
        MANDATORY_CARPENTER_RECIPES = CONFIGURATION.get("general", "mandatoryCarpenterRecipes", MANDATORY_CARPENTER_RECIPES, "Whether or not the Carpenter is required to craft Forestry related pipes/modules.").getBoolean(false);
        ENABLE_BETA_RECIPES = CONFIGURATION.get("general", "enableBetaRecipes", ENABLE_BETA_RECIPES, "Wether or not the Beta-Recipes for Stuff shall be used for pipes/modules.").getBoolean(false);
        ENABLE_PARTICLE_FX = CONFIGURATION.get("general", "enableParticleFX", ENABLE_PARTICLE_FX, "Whether or not special particles will spawn.").getBoolean(false);
        if (CONFIGURATION.hasKey(CATEGORY_MULTITHREAD, "enabled")) {
            CONFIGURATION.getCategory(CATEGORY_MULTITHREAD).remove((Object)"enabled");
        }
        if ((MULTI_THREAD_NUMBER = CONFIGURATION.get(CATEGORY_MULTITHREAD, "count", MULTI_THREAD_NUMBER, "Number of routing table update Threads, 0 to disable.").getInt()) < 0) {
            MULTI_THREAD_NUMBER = 0;
            CONFIGURATION.get(CATEGORY_MULTITHREAD, "count", MULTI_THREAD_NUMBER, "Number of routing table update Threads, 0 to disable.").set(Integer.toString(MULTI_THREAD_NUMBER));
        }
        if ((MULTI_THREAD_PRIORITY = CONFIGURATION.get(CATEGORY_MULTITHREAD, "priority", MULTI_THREAD_PRIORITY, "Priority of the multiThread Threads. 10 is highest, 5 normal, 1 lowest").getInt()) < 1 || MULTI_THREAD_PRIORITY > 10) {
            MULTI_THREAD_PRIORITY = 5;
            CONFIGURATION.get(CATEGORY_MULTITHREAD, "priority", MULTI_THREAD_PRIORITY, "Priority of the multiThread Threads. 10 is highest, 5 normal, 1 lowest").set(Integer.toString(5));
        }
        if ((POWER_USAGE_MULTIPLIER = CONFIGURATION.get("general", "powerUsageMultiplyer", POWER_USAGE_MULTIPLIER, "A Multiplyer for the power usage.").getDouble(POWER_USAGE_MULTIPLIER)) <= 0.0) {
            POWER_USAGE_MULTIPLIER = 1.0;
            CONFIGURATION.get("general", "powerUsageMultiplyer", POWER_USAGE_MULTIPLIER, "A Multiplyer for the power usage.").set(1);
        }
        LOGISTICS_CRAFTING_TABLE_POWER_USAGE = Math.max(CONFIGURATION.get("general", "logisticsCraftingTablePowerUsage", LOGISTICS_CRAFTING_TABLE_POWER_USAGE, "Number of LPower units the Logistics Crafting Table uses per craft.").getInt(), 0);
        CHECK_FOR_UPDATES = CONFIGURATION.get("general", "checkForUpdates", CHECK_FOR_UPDATES, "Should LogisticsPipes check for updates?").getBoolean(false);
        OPAQUE = CONFIGURATION.get("general", "OpaquePipes", OPAQUE, "Render every LP pipe opaque.").getBoolean(false);
        EASTER_EGGS = CONFIGURATION.get("general", "easterEggs", EASTER_EGGS, "Do you fancy easter eggs?").getBoolean(false);
        MAX_LOGISTICS_FLUID_TRANSPORT_INNER_CAPACITY = CONFIGURATION.get("general", "maxLogisticsFluidInnerCapacity", MAX_LOGISTICS_FLUID_TRANSPORT_INNER_CAPACITY, "Sets the maximum amount for a liquid that can be held in a fluid pipe. Default value: 10000 (1000 equals 1 Bucket for normal fluids). If you are playing GTNH this value represents liters (10000 = 10000L).").getInt();
        CONFIGURATION.save();
    }

    public static void savePopupState() {
        Property pageDisplayPopupProperty = CONFIGURATION.get("general", "displayPopup", DISPLAY_POPUP, "Set the default configuration for the popup of the Orderer Gui. Should it be used?");
        pageDisplayPopupProperty.set(Boolean.toString(DISPLAY_POPUP));
        CONFIGURATION.save();
    }

    static {
        LOGISTICS_DETECTION_LENGTH = 50;
        LOGISTICS_DETECTION_COUNT = 100;
        LOGISTICS_DETECTION_FREQUENCY = 600;
        LOGISTICS_ORDERER_COUNT_INVERTWHEEL = false;
        LOGISTICS_ORDERER_PAGE_INVERTWHEEL = false;
        MAX_UNROUTED_CONNECTIONS = 32;
        LOGISTICS_HUD_RENDER_DISTANCE = 15;
        pipeDurability = 0.25f;
        LOGISTICS_POWER_USAGE_DISABLED = false;
        ENABLE_RESEARCH_SYSTEM = false;
        TOOLTIP_INFO = LPConstants.DEBUG;
        MANDATORY_CARPENTER_RECIPES = true;
        ENABLE_BETA_RECIPES = false;
        ENABLE_PARTICLE_FX = true;
        DISPLAY_POPUP = true;
        MULTI_THREAD_NUMBER = 4;
        MULTI_THREAD_PRIORITY = 5;
        POWER_USAGE_MULTIPLIER = 1.0;
        LOGISTICS_CRAFTING_TABLE_POWER_USAGE = 250;
        CHECK_FOR_UPDATES = true;
        EASTER_EGGS = true;
        OPAQUE = false;
        MAX_ROBOT_DISTANCE = 64;
        MAX_LOGISTICS_FLUID_TRANSPORT_INNER_CAPACITY = 10000;
        loaded = false;
    }
}

