/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.utils.future;

import javax.annotation.concurrent.Immutable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;

@Immutable
public class Vector3i
implements Comparable<Vector3i> {
    public static final Vector3i ZERO = new Vector3i(0, 0, 0);
    private int x;
    private int y;
    private int z;

    public Vector3i(int xIn, int yIn, int zIn) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
    }

    public Vector3i(double xIn, double yIn, double zIn) {
        this(MathHelper.func_76128_c((double)xIn), MathHelper.func_76128_c((double)yIn), MathHelper.func_76128_c((double)zIn));
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vector3i)) {
            return false;
        }
        Vector3i vector3i = (Vector3i)p_equals_1_;
        if (this.getX() != vector3i.getX()) {
            return false;
        }
        if (this.getY() != vector3i.getY()) {
            return false;
        }
        return this.getZ() == vector3i.getZ();
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(Vector3i p_compareTo_1_) {
        if (this.getY() == p_compareTo_1_.getY()) {
            return this.getZ() == p_compareTo_1_.getZ() ? this.getX() - p_compareTo_1_.getX() : this.getZ() - p_compareTo_1_.getZ();
        }
        return this.getY() - p_compareTo_1_.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    protected void setX(int xIn) {
        this.x = xIn;
    }

    protected void setY(int yIn) {
        this.y = yIn;
    }

    protected void setZ(int zIn) {
        this.z = zIn;
    }

    public Vector3i above() {
        return this.above(1);
    }

    public Vector3i above(int n) {
        return this.relative(EnumFacing.UP, n);
    }

    public Vector3i below() {
        return this.below(1);
    }

    public Vector3i below(int n) {
        return this.relative(EnumFacing.DOWN, n);
    }

    public Vector3i relative(EnumFacing facing, int n) {
        return n == 0 ? this : new Vector3i(this.getX() + facing.func_82601_c() * n, this.getY() + facing.func_96559_d() * n, this.getZ() + facing.func_82599_e() * n);
    }

    public Vector3i cross(Vector3i vec) {
        return new Vector3i(this.getY() * vec.getZ() - this.getZ() * vec.getY(), this.getZ() * vec.getX() - this.getX() * vec.getZ(), this.getX() * vec.getY() - this.getY() * vec.getX());
    }

    public boolean closerThan(Vector3i vector, double distance) {
        return this.distSqr(vector.getX(), vector.getY(), vector.getZ(), false) < distance * distance;
    }

    public double distSqr(Vector3i to) {
        return this.distSqr(to.getX(), to.getY(), to.getZ(), true);
    }

    public double distSqr(double x, double y, double z, boolean useCenter) {
        double d0 = useCenter ? 0.5 : 0.0;
        double d1 = (double)this.getX() + d0 - x;
        double d2 = (double)this.getY() + d0 - y;
        double d3 = (double)this.getZ() + d0 - z;
        return d1 * d1 + d2 * d2 + d3 * d3;
    }

    public int distManhattan(Vector3i vector) {
        float f = Math.abs(vector.getX() - this.getX());
        float f1 = Math.abs(vector.getY() - this.getY());
        float f2 = Math.abs(vector.getZ() - this.getZ());
        return (int)(f + f1 + f2);
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }
}

