/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei.dumper;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.nei.dumper.GregTechIDDumper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MaterialDumper
extends GregTechIDDumper {
    public MaterialDumper() {
        super("material");
    }

    public String[] header() {
        return new String[]{"id", "name"};
    }

    @Override
    protected Iterable<String[]> dump(GregTechIDDumper.Mode mode) {
        ArrayList<String[]> dump = new ArrayList<String[]>();
        Map<Integer, Materials> idMap = Arrays.stream(GregTechAPI.sGeneratedMaterials).filter(Objects::nonNull).collect(Collectors.toMap(m -> m.mMetaItemSubID, m -> m));
        for (int i = 0; i < 1000; ++i) {
            if (mode == GregTechIDDumper.Mode.FREE && !idMap.containsKey(i)) {
                dump.add(new String[]{String.valueOf(i), ""});
                continue;
            }
            if (mode != GregTechIDDumper.Mode.USED || !idMap.containsKey(i)) continue;
            dump.add(new String[]{String.valueOf(i), idMap.get((Object)Integer.valueOf((int)i)).mName});
        }
        return dump;
    }
}

