/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.LongData;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;

public class LongRunningAverage
implements LongData {
    private final long[] data;
    private long sumHigh;
    private long sumLow;
    private int ptr;
    private boolean filled;
    private final Collection<View> views = Collections.newSetFromMap(new WeakHashMap());

    public LongRunningAverage(int size) {
        if (size <= 1) {
            throw new IllegalArgumentException("Size must be greater than 1");
        }
        this.data = new long[size];
    }

    public void update(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Value must not be negative");
        }
        long high = this.sumHigh;
        long low = this.sumLow;
        high += (low += value) < 0L ? 1L : 0L;
        low &= Long.MAX_VALUE;
        if (this.filled) {
            high -= (low -= this.data[this.ptr]) < 0L ? 1L : 0L;
            low &= Long.MAX_VALUE;
        }
        this.sumHigh = high;
        this.sumLow = low;
        for (View view : this.views) {
            view.update(value);
        }
        this.data[this.ptr++] = value;
        if (this.ptr == this.data.length) {
            this.ptr = 0;
            this.filled = true;
        }
    }

    @Override
    public int size() {
        int length = this.filled ? this.data.length : this.ptr;
        return length;
    }

    @Override
    public BigInteger sum() {
        long high = this.sumHigh;
        long low = this.sumLow;
        if ((high & 1L) == 1L) {
            low |= Long.MIN_VALUE;
        }
        byte[] byteArray = new byte[16];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
        byteBuffer.putLong(high >>>= 1);
        byteBuffer.putLong(low);
        return new BigInteger(byteArray);
    }

    public LongData view(int size) {
        if (size <= 1) {
            throw new IllegalArgumentException("Size must be greater than 1");
        }
        if (size > this.data.length) {
            throw new IllegalArgumentException("Size must be less than or equal to limit of current ring buffer");
        }
        if (size == this.data.length) {
            return this;
        }
        return new View(size);
    }

    private class View
    implements LongData {
        private final int size;
        private long sumHigh;
        private long sumLow;

        public View(int size) {
            this.size = size;
            LongRunningAverage.this.views.add(this);
            if (LongRunningAverage.this.ptr > 0 || LongRunningAverage.this.filled) {
                ByteBuffer buf = ByteBuffer.allocate(16);
                buf.put(this.sumSlow().toByteArray());
                buf.flip();
                this.sumLow = buf.getLong();
                this.sumHigh = buf.getLong();
            }
        }

        @Override
        public int size() {
            return Math.min(LongRunningAverage.this.size(), this.size);
        }

        @Override
        public BigInteger sum() {
            long high = this.sumHigh;
            long low = this.sumLow;
            if ((high & 1L) == 1L) {
                low |= Long.MIN_VALUE;
            }
            byte[] byteArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
            byteBuffer.putLong(high >>>= 1);
            byteBuffer.putLong(low);
            return new BigInteger(byteArray);
        }

        public BigInteger sumSlow() {
            int start = this.getStart();
            long high = 0L;
            long low = LongRunningAverage.this.data[start];
            int end = LongRunningAverage.this.ptr;
            for (int i = start + 1; i != end; ++i) {
                long num;
                if (i == LongRunningAverage.this.data.length) {
                    i = 0;
                    if (end == 0) break;
                }
                high += (low += (num = LongRunningAverage.this.data[i])) < 0L ? 1L : 0L;
                low &= Long.MAX_VALUE;
            }
            if ((high & 1L) == 1L) {
                low |= Long.MIN_VALUE;
            }
            byte[] byteArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
            byteBuffer.putLong(high >>>= 1);
            byteBuffer.putLong(low);
            return new BigInteger(byteArray);
        }

        private int getStart() {
            int start = LongRunningAverage.this.ptr - this.size;
            if (start < 0) {
                start = LongRunningAverage.this.filled ? (start += LongRunningAverage.this.data.length) : 0;
            }
            return start;
        }

        public void update(long value) {
            long high = this.sumHigh;
            long low = this.sumLow;
            high += (low += value) < 0L ? 1L : 0L;
            low &= Long.MAX_VALUE;
            int start = this.getStart();
            if (this.size() == this.size) {
                high -= (low -= LongRunningAverage.this.data[start]) < 0L ? 1L : 0L;
                low &= Long.MAX_VALUE;
            }
            this.sumHigh = high;
            this.sumLow = low;
        }
    }
}

