/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.structure;

import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.GTMod;
import gregtech.api.casing.ICasing;
import gregtech.api.casing.ICasingGroup;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.structure.CasingInfo;
import gregtech.api.structure.IStructureChannels;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.util.GTDataUtils;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.IGTHatchAdder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.chars.Char2IntArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class StructureWrapper<MTE extends MTEMultiBlockBase & IStructureProvider<MTE>> {
    public static final String STRUCTURE_SHAPE_MAIN = "main";
    public final IStructureProvider<MTE> provider;
    public IStructureDefinition<MTE> structureDefinition;
    public Vec3Impl controllerOffset;
    public Vec3Impl minSize;
    public Vec3Impl maxSize;
    public Char2ObjectArrayMap<CasingInfo<MTE>> casings;
    public Char2IntArrayMap minCasingCounts;
    public Char2IntArrayMap maxCasingCounts;
    public Function<MTE, IStructureInstance<MTE>> instanceExtractor;

    public StructureWrapper(IStructureProvider<MTE> provider) {
        this.provider = provider;
    }

    public void loadStructure() {
        this.structureDefinition = null;
        this.casings = new Char2ObjectArrayMap();
        this.minCasingCounts = new Char2IntArrayMap();
        this.maxCasingCounts = new Char2IntArrayMap();
        this.controllerOffset = null;
        try {
            String[][] definitionText = this.provider.getDefinition();
            this.analyzeMinDefinition(definitionText);
            this.analyzeMaxDefinition();
            this.structureDefinition = this.provider.compile(definitionText);
        }
        catch (Throwable t) {
            GTMod.GT_FML_LOGGER.error("Could not compile structure", t);
        }
    }

    private void analyzeMinDefinition(String[][] definitionText) {
        int width = 0;
        int height = 0;
        int length = definitionText.length;
        int z = 0;
        for (String[] a : definitionText) {
            int y = 0;
            height = Math.max(height, a.length);
            for (String b : a) {
                width = Math.max(width, b.length());
                for (int x = 0; x < b.length(); ++x) {
                    char c = b.charAt(x);
                    if (c == ' ' || c == '-' || c == '+') continue;
                    this.minCasingCounts.mergeInt(c, 1, Integer::sum);
                    if (c != '~') continue;
                    if (this.controllerOffset != null) {
                        throw new IllegalStateException("Structure definition for " + this.provider + " contains two tildes");
                    }
                    this.controllerOffset = new Vec3Impl(x, y, z);
                }
                ++y;
            }
            ++z;
        }
        this.minSize = new Vec3Impl(width, height, length);
        if (this.controllerOffset == null) {
            throw new IllegalStateException("Structure definition for " + this.provider + " did not contain a tilde! This is required so that the wrapper knows where the controller is.");
        }
    }

    private void analyzeMaxDefinition() {
        String[][] maxDefinitionText = this.provider.getMaxDefinition();
        int width = 0;
        int height = 0;
        int length = maxDefinitionText.length;
        for (String[] a : maxDefinitionText) {
            height = Math.max(height, a.length);
            for (String b : a) {
                width = Math.max(width, b.length());
                for (char c : b.toCharArray()) {
                    if (c == ' ' || c == '-' || c == '+' || c == '~') continue;
                    this.maxCasingCounts.mergeInt(c, 1, Integer::sum);
                }
            }
        }
        this.maxSize = new Vec3Impl(width, height, length);
    }

    private void ensureStructureLoaded() {
        if (this.structureDefinition == null) {
            this.loadStructure();
        }
    }

    public IStructureDefinition<MTE> getStructureDefinition() {
        return this.structureDefinition;
    }

    public Vec3Impl getControllerOffset() {
        return this.controllerOffset;
    }

    public Vec3Impl getMinSize() {
        return this.minSize;
    }

    public Vec3Impl getMaxSize() {
        return this.maxSize;
    }

    public boolean checkStructure(MTE instance) {
        return this.checkStructure(instance, STRUCTURE_SHAPE_MAIN, null);
    }

    public boolean checkStructure(MTE instance, String piece, Vec3Impl pieceOffset) {
        this.ensureStructureLoaded();
        if (!GTValues.DEVENV) {
            return this.checkStructureImpl(instance, piece, pieceOffset);
        }
        try {
            return this.checkStructureImpl(instance, piece, pieceOffset);
        }
        catch (NoSuchMethodError e) {
            GTMod.GT_FML_LOGGER.info("Caught an exception that was probably caused by a hotswap.", (Throwable)e);
            this.loadStructure();
            return this.checkStructureImpl(instance, piece, pieceOffset);
        }
    }

    private boolean checkStructureImpl(MTE instance, String piece, Vec3Impl pieceOffset) {
        IGregTechTileEntity tTile = ((MetaTileEntity)instance).getBaseMetaTileEntity();
        return this.structureDefinition.check(instance, piece, tTile.getWorld(), ((IAlignment)instance).getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.controllerOffset.get0() + (pieceOffset == null ? 0 : pieceOffset.get0()), this.controllerOffset.get1() + (pieceOffset == null ? 0 : pieceOffset.get1()), this.controllerOffset.get2() + (pieceOffset == null ? 0 : pieceOffset.get2()), !((MTEMultiBlockBase)instance).mMachine);
    }

    public void construct(MTE instance, ItemStack trigger, boolean hintsOnly) {
        this.construct(instance, trigger, hintsOnly, STRUCTURE_SHAPE_MAIN, null);
    }

    public void construct(MTE instance, ItemStack trigger, boolean hintsOnly, String piece, Vec3Impl pieceOffset) {
        this.ensureStructureLoaded();
        if (!GTValues.DEVENV) {
            this.constructImpl(instance, trigger, hintsOnly, piece, pieceOffset);
        } else {
            try {
                this.constructImpl(instance, trigger, hintsOnly, piece, pieceOffset);
            }
            catch (NoSuchMethodError e) {
                GTMod.GT_FML_LOGGER.info("Caught an exception that was probably caused by a hotswap.", (Throwable)e);
                this.loadStructure();
                this.constructImpl(instance, trigger, hintsOnly, piece, pieceOffset);
            }
        }
    }

    private void constructImpl(MTE instance, ItemStack trigger, boolean hintsOnly, String piece, Vec3Impl pieceOffset) {
        IGregTechTileEntity tTile = ((MetaTileEntity)instance).getBaseMetaTileEntity();
        this.structureDefinition.buildOrHints(instance, trigger, piece, tTile.getWorld(), ((IAlignment)instance).getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.controllerOffset.get0() + (pieceOffset == null ? 0 : pieceOffset.get0()), this.controllerOffset.get1() + (pieceOffset == null ? 0 : pieceOffset.get1()), this.controllerOffset.get2() + (pieceOffset == null ? 0 : pieceOffset.get2()), hintsOnly);
    }

    public int survivalConstruct(MTE instance, ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalConstruct(instance, trigger, elementBudget, env, STRUCTURE_SHAPE_MAIN, null);
    }

    public int survivalConstruct(MTE instance, ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env, String piece, Vec3Impl pieceOffset) {
        if (((MTEMultiBlockBase)instance).mMachine) {
            return -1;
        }
        this.ensureStructureLoaded();
        if (!GTValues.DEVENV) {
            return this.survivalConstructImpl(instance, trigger, elementBudget, env, piece, pieceOffset);
        }
        try {
            return this.survivalConstructImpl(instance, trigger, elementBudget, env, piece, pieceOffset);
        }
        catch (NoSuchMethodError e) {
            GTMod.GT_FML_LOGGER.info("Caught an exception that was probably caused by a hotswap.", (Throwable)e);
            this.loadStructure();
            return this.survivalConstructImpl(instance, trigger, elementBudget, env, piece, pieceOffset);
        }
    }

    private int survivalConstructImpl(MTE instance, ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env, String piece, Vec3Impl pieceOffset) {
        IGregTechTileEntity tTile = ((MetaTileEntity)instance).getBaseMetaTileEntity();
        int built = this.structureDefinition.survivalBuild(instance, trigger, piece, tTile.getWorld(), ((IAlignment)instance).getExtendedFacing(), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.controllerOffset.get0() + (pieceOffset == null ? 0 : pieceOffset.get0()), this.controllerOffset.get1() + (pieceOffset == null ? 0 : pieceOffset.get1()), this.controllerOffset.get2() + (pieceOffset == null ? 0 : pieceOffset.get2()), elementBudget, env, false);
        if (built > 0) {
            ((MTEMultiBlockBase)instance).checkStructure(true, tTile);
        }
        return built;
    }

    public IStructureElement<MTE> getStructureElement(char c) {
        IStructureElement element;
        CasingInfo casing = (CasingInfo)this.casings.get(c);
        if (casing.elementOverride != null) {
            element = casing.elementOverride.apply(casing.casingGroup);
        } else if (casing.maxHatches != 0) {
            Objects.requireNonNull(casing.casing, "CasingInfo.casing cannot be null");
            element = StructureUtility.onElementPass(instance -> ((IStructureProvider)((Object)instance)).getStructureInstance().onCasingEncountered(c), casing.casing.asElement(casing));
            IHatchElement<? super MTE>[] hatches = casing.hatches;
            if (casing.casing.isTiered()) {
                hatches = GTDataUtils.mapToArray(casing.hatches, IHatchElement[]::new, hatch -> new HatchInterceptor(casing, hatch));
            }
            element = HatchElementBuilder.builder().atLeast(hatches).casingIndex(casing.casing.getTextureId()).dot(casing.dot).buildAndChain(element);
        } else {
            element = casing.casing.asElement(casing);
        }
        if (casing.channel != null) {
            element = casing.channel.use(element);
        }
        if (casing.elementWrapper != null) {
            element = casing.elementWrapper.apply(element);
        }
        return element;
    }

    public int getCasingMin(char c) {
        CasingInfo casing = (CasingInfo)this.casings.get(c);
        if (casing.maxHatches < 0) {
            return 0;
        }
        return this.minCasingCounts.get(c) - casing.maxHatches;
    }

    public int getCasingMin(ICasing casing) {
        int sum = 0;
        for (Char2ObjectMap.Entry e : this.casings.char2ObjectEntrySet()) {
            if (((CasingInfo)e.getValue()).casing != casing) continue;
            sum += this.getCasingMin(e.getCharKey());
        }
        return sum;
    }

    public int getCasingMax(char c) {
        return this.maxCasingCounts.get(c);
    }

    public int getCasingMax(ICasing casing) {
        int sum = 0;
        for (Char2ObjectMap.Entry e : this.casings.char2ObjectEntrySet()) {
            if (((CasingInfo)e.getValue()).casing != casing) continue;
            sum += this.getCasingMax(e.getCharKey());
        }
        return sum;
    }

    public CasingBuilder addCasing(char c, @Nonnull ICasing casing) {
        CasingInfo casingInfo = new CasingInfo();
        casingInfo.casing = casing;
        casingInfo.casingGroup = ICasingGroup.ofCasing(casing);
        casingInfo.instanceExtractor = this.instanceExtractor;
        this.casings.put(c, casingInfo);
        return new CasingBuilder(c, casingInfo);
    }

    public StructureDefinition.Builder<MTE> getStructureBuilder(List<Pair<String, String[][]>> shapes) {
        StructureDefinition.Builder builder = StructureDefinition.builder();
        CharIterator charIterator = this.casings.keySet().iterator();
        while (charIterator.hasNext()) {
            char c = ((Character)charIterator.next()).charValue();
            builder.addElement(c, this.getStructureElement(c));
        }
        for (Pair pair : shapes) {
            builder.addShape((String)pair.left(), (String[][])pair.right());
        }
        return builder;
    }

    public IStructureDefinition<MTE> buildStructure(String[][] definition) {
        return this.getStructureBuilder(Arrays.asList(Pair.of((Object)STRUCTURE_SHAPE_MAIN, (Object)definition))).build();
    }

    public class CasingBuilder {
        private final char c;
        private final CasingInfo<MTE> casingInfo;

        public CasingBuilder(char c, CasingInfo<MTE> casingInfo) {
            this.c = c;
            this.casingInfo = casingInfo;
        }

        public CasingBuilder withUnlimitedHatches(int dot, List<IHatchElement<? super MTE>> hatches) {
            Objects.requireNonNull(hatches);
            this.casingInfo.dot = dot;
            this.casingInfo.maxHatches = -1;
            this.casingInfo.hatches = hatches.toArray(new IHatchElement[0]);
            return this;
        }

        public CasingBuilder withHatches(int dot, int maxHatches, List<IHatchElement<? super MTE>> hatches) {
            Objects.requireNonNull(hatches);
            this.casingInfo.dot = dot;
            this.casingInfo.maxHatches = maxHatches;
            this.casingInfo.hatches = hatches.toArray(new IHatchElement[0]);
            return this;
        }

        public CasingBuilder withChannel(IStructureChannels channel) {
            this.casingInfo.channel = channel;
            return this;
        }

        public CasingBuilder withElement(IStructureElement<MTE> element) {
            this.casingInfo.elementOverride = ignored -> element;
            return this;
        }

        public CasingBuilder withElement(Function<ICasingGroup, IStructureElement<MTE>> element) {
            this.casingInfo.elementOverride = element;
            return this;
        }

        public CasingBuilder wrapElement(Function<IStructureElement<MTE>, IStructureElement<MTE>> wrapper) {
            this.casingInfo.elementWrapper = wrapper;
            return this;
        }

        public CasingBuilder withCasingGroup(ICasingGroup group) {
            this.casingInfo.casingGroup = group;
            return this;
        }
    }

    static class HatchInterceptor<T>
    extends GTStructureUtility.ProxyHatchElement<T> {
        private final CasingInfo<T> casing;

        public HatchInterceptor(CasingInfo<T> casing, IHatchElement<? super T> element) {
            super(element);
            this.casing = casing;
        }

        @Override
        public IGTHatchAdder<? super T> adder() {
            IGTHatchAdder realAdder = super.adder();
            return (t, hatch, textureId) -> {
                if (realAdder.apply(t, hatch, textureId)) {
                    IMetaTileEntity patt13586$temp = hatch.getMetaTileEntity();
                    if (patt13586$temp instanceof MTEHatch) {
                        MTEHatch hatch2 = (MTEHatch)patt13586$temp;
                        this.casing.getInstance((T)t).addTieredHatch(hatch2, this.casing.casing, this.casing);
                    }
                    return true;
                }
                return false;
            };
        }
    }
}

